/*
 * Decompiled with CFR 0.152.
 */
package blasty.manHunt.randomPotions;

import blasty.manHunt.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class RandomPotionGiver {
    private static final Random random = new Random();
    private JavaPlugin plugin;
    private final Map<UUID, BukkitRunnable> activeTasks = new HashMap<UUID, BukkitRunnable>();

    public RandomPotionGiver(JavaPlugin plugin) {
        this.plugin = plugin;
        Constants.potionEffects.add(PotionEffectType.HASTE);
        Constants.potionEffects.add(PotionEffectType.RESISTANCE);
        Constants.potionEffects.add(PotionEffectType.DOLPHINS_GRACE);
        Constants.potionEffects.add(PotionEffectType.FIRE_RESISTANCE);
        Constants.potionEffects.add(PotionEffectType.REGENERATION);
        Constants.potionEffects.add(PotionEffectType.MINING_FATIGUE);
        Constants.potionEffects.add(PotionEffectType.HERO_OF_THE_VILLAGE);
        Constants.potionEffects.add(PotionEffectType.ABSORPTION);
        Constants.potionEffects.add(PotionEffectType.BAD_OMEN);
        Constants.potionEffects.add(PotionEffectType.BLINDNESS);
        Constants.potionEffects.add(PotionEffectType.CONDUIT_POWER);
        Constants.potionEffects.add(PotionEffectType.DARKNESS);
        Constants.potionEffects.add(PotionEffectType.GLOWING);
        Constants.potionEffects.add(PotionEffectType.HEALTH_BOOST);
        Constants.potionEffects.add(PotionEffectType.HUNGER);
        Constants.potionEffects.add(PotionEffectType.INFESTED);
        Constants.potionEffects.add(PotionEffectType.INSTANT_HEALTH);
        Constants.potionEffects.add(PotionEffectType.SATURATION);
        Constants.potionEffects.add(PotionEffectType.INVISIBILITY);
        Constants.potionEffects.add(PotionEffectType.JUMP_BOOST);
        Constants.potionEffects.add(PotionEffectType.LEVITATION);
        Constants.potionEffects.add(PotionEffectType.LUCK);
        Constants.potionEffects.add(PotionEffectType.NAUSEA);
        Constants.potionEffects.add(PotionEffectType.NIGHT_VISION);
        Constants.potionEffects.add(PotionEffectType.SLOW_FALLING);
        Constants.potionEffects.add(PotionEffectType.SPEED);
        Constants.potionEffects.add(PotionEffectType.WEAKNESS);
        Constants.potionEffects.add(PotionEffectType.WATER_BREATHING);
        Constants.potionEffects.add(PotionEffectType.WIND_CHARGED);
        Constants.potionEffects.add(PotionEffectType.POISON);
    }

    public void givePlayerRandomPotion(Player player) {
        ArrayList<PotionEffectType> effects = Constants.potionEffects;
        if (effects.isEmpty()) {
            return;
        }
        PotionEffectType type = (PotionEffectType)effects.get(random.nextInt(effects.size()));
        PotionEffect effect = new PotionEffect(type, 1200, 0);
        player.addPotionEffect(effect);
    }

    public void startRepeatingPotionTask(final Player player) {
        UUID uuid = player.getUniqueId();
        if (this.activeTasks.containsKey(uuid)) {
            return;
        }
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                RandomPotionGiver.this.givePlayerRandomPotion(player);
            }
        };
        task.runTaskTimer((Plugin)this.plugin, 0L, 6000L);
        this.activeTasks.put(uuid, task);
    }

    public void stopPotionTask(Player player) {
        UUID uuid = player.getUniqueId();
        BukkitRunnable task = this.activeTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }
}

