/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot.ui;

import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import world.landfall.slipboot.Slipboot;
import world.landfall.slipboot.WarpLocations;
import world.landfall.slipboot.client.ClientWarpData;
import world.landfall.slipboot.networking.WarpPacket;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WarpScreen
extends Screen {
    private final Player player;
    private final BlockPos pos;
    private Map<Integer, WarpLocations.WarpLocation> locations;
    private LocationListWidget locationListWidget;

    public WarpScreen(BlockPos pos, Player player) {
        super((Component)Component.translatable((String)"screen.slipboot.warp"));
        this.minecraft = Minecraft.getInstance();
        this.pos = pos;
        this.player = player;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void init() {
        super.init();
        this.locations = ClientWarpData.getLocations();
        if (this.locations.isEmpty()) {
            Slipboot.LOGGER.warn("WarpScreen: No warp locations available on client");
        }
        this.locationListWidget = new LocationListWidget(Minecraft.getInstance(), 300, 150, (this.width - 300) / 2, (this.height - 200) / 2, 20);
        this.addRenderableWidget((GuiEventListener)this.locationListWidget);
        if (this.locations != null) {
            for (Integer i : this.locations.keySet()) {
                WarpLocations.WarpLocation location = this.locations.get(i);
                if (this.pos.equals((Object)location.pos)) continue;
                this.locationListWidget.addEntry(new LocationListWidget.Entry(location.id));
            }
        }
        Button button = new Button.Builder((Component)Component.translatable((String)"gui.warp.button.warp"), new Button.OnPress(){

            public void onPress(Button button) {
                for (WarpLocations.WarpLocation x : ClientWarpData.getLocations().values()) {
                    if (WarpScreen.this.locationListWidget.getSelected() == null || x.id != ((LocationListWidget.Entry)WarpScreen.this.locationListWidget.getSelected()).locationID || WarpScreen.this.locations == null || WarpScreen.this.locations.get(((LocationListWidget.Entry)WarpScreen.this.locationListWidget.getSelected()).locationID) == null || WarpScreen.this.locations.get((Object)Integer.valueOf((int)((LocationListWidget.Entry)WarpScreen.this.locationListWidget.getSelected()).locationID)).pos.equals((Object)WarpScreen.this.pos) || !WarpScreen.this.locations.get((Object)Integer.valueOf((int)((LocationListWidget.Entry)WarpScreen.this.locationListWidget.getSelected()).locationID)).active) continue;
                    ResourceLocation levelResourceLocation = ResourceLocation.parse((String)x.level);
                    BlockPos newPos = x.pos.above().above();
                    PacketDistributor.sendToServer((CustomPacketPayload)new WarpPacket(WarpScreen.this.player.getName().getString(), new Vector3f((float)newPos.getX() + 0.5f, (float)newPos.getY(), (float)newPos.getZ() + 0.5f), levelResourceLocation.toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    WarpScreen.this.onClose();
                }
            }
        }).build();
        button.setX((this.width - 150) / 2);
        button.setY((this.height - 20) / 2 + 70);
        this.addRenderableWidget((GuiEventListener)button);
    }

    private static class LocationListWidget
    extends ObjectSelectionList<Entry> {
        public LocationListWidget(Minecraft minecraft, int width, int height, int x, int y, int itemHeight) {
            super(minecraft, width, height, y, itemHeight);
            this.setX(x);
        }

        public int addEntry(@NotNull Entry e) {
            return super.addEntry((AbstractSelectionList.Entry)e);
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }

        protected void renderDecorations(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            super.renderDecorations(guiGraphics, mouseX, mouseY);
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        protected static class Entry
        extends ObjectSelectionList.Entry<Entry> {
            public final int locationID;

            public Entry(int id) {
                this.locationID = id;
            }

            public void render(GuiGraphics guiGraphics, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
                WarpLocations.WarpLocation location = ClientWarpData.getLocation(this.locationID);
                if (location == null) {
                    guiGraphics.drawString(Minecraft.getInstance().font, "Warp #" + this.locationID, i2 + 2, i1 + 4, 0xAAAAAA);
                    return;
                }
                guiGraphics.drawString(Minecraft.getInstance().font, location.name, i2 + 2, i1 + 4, location.active ? 0xFFFFFF : 0xAAAAAA);
            }

            public Component getNarration() {
                return Component.literal((String)"Womp womp");
            }
        }
    }

    private static final class Colors {
        static final int PANEL_BACKGROUND = Integer.MIN_VALUE;
        static final int SCROLLBAR_TRACK = -2144128205;
        static final int SCROLLBAR_THUMB = -4473925;
        static final int TEXT_COLOR = 0xFFFFFF;
        static final int GRAY_TEXT_COLOR = 0xAAAAAA;
        static final int ACTIVE_CHARACTER = 65280;
        static final int SWITCH_BUTTON = 0x66CCFF;
        static final int DELETE_BUTTON = 0xFF0000;
        static final int CREATE_BUTTON = 65280;

        private Colors() {
        }
    }

    private static final class Layout {
        static final int BUTTON_HEIGHT = 20;
        static final int LIST_ITEM_HEIGHT = 25;
        static final int MAX_VISIBLE_ITEMS = 5;
        static final int CREATE_BUTTON_SIZE = 20;
        static final int LIST_WIDTH = 300;
        static final int LIST_HEIGHT = 150;
        static final int BUTTON_Y_OFFSET = 2;
        static final int SWITCH_BUTTON_X_WITH_DELETE = 239;
        static final int SWITCH_BUTTON_X_WITHOUT_DELETE = 264;
        static final int DELETE_BUTTON_X = 264;
        static final int SCROLLBAR_WIDTH = 8;
        static final int SCROLLBAR_MARGIN = 3;
        static final int MIN_THUMB_HEIGHT = 15;
        static final int PANEL_PADDING = 5;
        static final int TITLE_Y_OFFSET = 20;
        static final int NAME_Y_OFFSET = 6;

        private Layout() {
        }
    }
}

