/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;
import world.landfall.slipboot.BlueMapIntegration;
import world.landfall.slipboot.Config;
import world.landfall.slipboot.ModBlockEntities;
import world.landfall.slipboot.ModBlocks;
import world.landfall.slipboot.ModCommands;
import world.landfall.slipboot.ModItems;
import world.landfall.slipboot.ModMenuTypes;
import world.landfall.slipboot.WarpLocations;
import world.landfall.slipboot.blocks.WarpBlock;
import world.landfall.slipboot.client.ClientWarpData;
import world.landfall.slipboot.networking.SyncWarpLocationsPacket;

@Mod(value="slipboot")
public class Slipboot {
    public static final String MODID = "slipboot";
    public static WarpLocations locationData;
    public static final Logger LOGGER;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB;

    public Slipboot(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerScreens);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModItems.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void registerScreens(RegisterMenuScreensEvent event) {
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Common setup");
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (locationData != null) {
                LOGGER.info("Syncing warp locations to player: {}", (Object)serverPlayer.getName().getString());
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)SyncWarpLocationsPacket.create(locationData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Setting up server");
        if (Config.doBluemapIntegration) {
            try {
                BlueMapIntegration.init(event.getServer().getAllLevels());
            }
            catch (Exception | NoClassDefFoundError e) {
                LOGGER.warn("BlueMap integration failed - BlueMap API not available or error occurred: " + e.getMessage());
            }
        }
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getServer().createCommandSourceStack().dispatcher());
        DimensionDataStorage dataStorage = Objects.requireNonNull(event.getServer().getLevel(Level.OVERWORLD)).getDataStorage();
        SavedData.Factory factory = new SavedData.Factory(WarpLocations::create, WarpLocations::load);
        locationData = (WarpLocations)dataStorage.computeIfAbsent(factory, "warp_locations");
        WarpBlock.setLocationData(locationData);
    }

    static {
        LOGGER = LogUtils.getLogger();
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)MODID);
        EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.slipboot")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((BlockItem)ModItems.REPAIRABLE_BLOCK_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> output.accept((ItemLike)ModItems.WARP_BLOCK_ITEM.get())).build());
    }

    @EventBusSubscriber(modid="slipboot", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
            ClientWarpData.clear();
            LOGGER.info("Cleared client warp data on disconnect");
        }
    }

    @EventBusSubscriber(modid="slipboot", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("Client setup - initializing client-side components");
            event.enqueueWork(() -> LOGGER.info("Client setup work enqueued - client initialization complete"));
        }
    }
}

