/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import world.landfall.slipboot.BlueMapIntegration;
import world.landfall.slipboot.Config;
import world.landfall.slipboot.Slipboot;
import world.landfall.slipboot.networking.UpdateWarpLocationPacket;

public class WarpLocations
extends SavedData {
    private final HashMap<Integer, WarpLocation> locations = new HashMap();

    public static WarpLocations create() {
        return new WarpLocations();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag locationsTag = new ListTag();
        for (WarpLocation x : this.locations.values()) {
            CompoundTag newTag = new CompoundTag();
            newTag.putString("name", x.name);
            newTag.putIntArray("pos", new int[]{x.pos.getX(), x.pos.getY(), x.pos.getZ()});
            newTag.putBoolean("active", x.active);
            newTag.putInt("id", x.id);
            newTag.putString("level", x.level);
            locationsTag.add((Object)newTag);
        }
        compoundTag.put("locations", (Tag)locationsTag);
        return compoundTag;
    }

    public static WarpLocations load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        WarpLocations data = WarpLocations.create();
        for (Tag tag2 : tag.getList("locations", 10)) {
            if (!(tag2 instanceof CompoundTag)) continue;
            CompoundTag y = (CompoundTag)tag2;
            int[] posArray = y.getIntArray("pos");
            BlockPos pos = BlockPos.containing((double)posArray[0], (double)posArray[1], (double)posArray[2]);
            WarpLocation location = new WarpLocation(y.getString("name"), pos, y.getInt("id"), y.getBoolean("active"), y.getString("level"));
            data.locations.put(location.id, location);
        }
        if (Config.doBluemapIntegration) {
            try {
                for (WarpLocation warpLocation : data.locations.values()) {
                    BlueMapIntegration.addMarker(warpLocation.pos, warpLocation.name, warpLocation.id, ResourceLocation.parse((String)warpLocation.level));
                }
            }
            catch (Exception | NoClassDefFoundError e) {
                Slipboot.LOGGER.warn("Failed to add BlueMap markers: " + e.getMessage());
            }
        }
        return data;
    }

    public HashMap<Integer, WarpLocation> getLocations() {
        return this.locations;
    }

    private int getLargestID(HashMap<Integer, WarpLocation> map) {
        int max = -1;
        for (WarpLocation x : map.values()) {
            if (x.id <= max) continue;
            max = x.id;
        }
        return max;
    }

    public int addLocation(String name, BlockPos pos, boolean active, String level) {
        WarpLocation newLocation = new WarpLocation(name, pos, !this.locations.isEmpty() ? this.getLargestID(this.locations) + 1 : 0, active, level);
        for (WarpLocation x : this.locations.values()) {
            if (!x.equals(newLocation)) continue;
            return -1;
        }
        this.locations.put(newLocation.id, newLocation);
        if (Config.doBluemapIntegration) {
            try {
                BlueMapIntegration.addMarker(pos, name, newLocation.id, ResourceLocation.parse((String)newLocation.level));
            }
            catch (Exception | NoClassDefFoundError e) {
                Slipboot.LOGGER.warn("Failed to add BlueMap marker: " + e.getMessage());
            }
        }
        this.setDirty();
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)UpdateWarpLocationPacket.createAdd(newLocation.id, name, pos, active, level), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return newLocation.id;
    }

    public boolean setActive(int id, boolean active) {
        this.setDirty();
        WarpLocation loc = this.locations.get(id);
        if (loc != null) {
            loc.active = active;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)UpdateWarpLocationPacket.createUpdateActive(id, active), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public boolean removeLocation(int id) {
        boolean removed;
        this.setDirty();
        if (Config.doBluemapIntegration) {
            try {
                BlueMapIntegration.removeMarker(id, ResourceLocation.parse((String)this.locations.get((Object)Integer.valueOf((int)id)).level));
            }
            catch (Exception | NoClassDefFoundError e) {
                Slipboot.LOGGER.warn("Failed to remove BlueMap marker: " + e.getMessage());
            }
        }
        boolean bl = removed = this.locations.remove(id) != null;
        if (removed) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)UpdateWarpLocationPacket.createRemove(id), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return removed;
    }

    public boolean setName(int id, String name) {
        this.setDirty();
        WarpLocation loc = this.locations.get(id);
        if (loc != null) {
            loc.name = name;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)UpdateWarpLocationPacket.createUpdateName(id, name), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public int getId(BlockPos pos) {
        for (WarpLocation x : this.locations.values()) {
            if (!x.pos.equals((Object)pos)) continue;
            return x.id;
        }
        return -1;
    }

    public int search(String name) {
        for (WarpLocation x : this.locations.values()) {
            if (!x.name.equals(name)) continue;
            return x.id;
        }
        return -1;
    }

    public WarpLocation getLocation(int id) {
        for (WarpLocation x : this.locations.values()) {
            if (x.id != id) continue;
            return x;
        }
        return null;
    }

    public static class WarpLocation {
        public String name;
        public int id;
        public BlockPos pos;
        public boolean active;
        public String level;

        public WarpLocation(String name, BlockPos pos, int id, boolean active, String level) {
            this.name = name;
            this.pos = pos;
            this.active = active;
            this.id = id;
            this.level = level;
        }

        public boolean equals(WarpLocation e) {
            return this.pos.equals((Object)e.pos);
        }
    }
}

