/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import world.landfall.slipboot.blocks.RepairableBlockEntity;

public class RepairableBlock
extends BaseEntityBlock
implements EntityBlock {
    static final EnumProperty<BrokenState> brokenState = EnumProperty.create((String)"broken_state", BrokenState.class);
    String repairItem;

    public RepairableBlock(BlockBehaviour.Properties properties, String repairItem) {
        super(properties);
        this.repairItem = repairItem;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(brokenState, (Comparable)((Object)BrokenState.INTACT)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return switch (((BrokenState)((Object)state.getValue(brokenState))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                if (stack.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.repairItem)))) {
                    level.setBlock(pos, (BlockState)state.setValue(brokenState, (Comparable)((Object)BrokenState.INTACT)), 3);
                    stack.shrink(1);
                    yield ItemInteractionResult.SUCCESS;
                }
                yield ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            case 0 -> ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{brokenState});
        super.createBlockStateDefinition(builder);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.isCreative()) {
            return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        }
        this.spawnDestroyParticles(level, player, pos, state);
        level.setBlock(pos, (BlockState)state.setValue(brokenState, (Comparable)((Object)BrokenState.BROKEN)), 3);
        player.swing(InteractionHand.MAIN_HAND);
        level.playSound(player, pos, SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.BLOCKS);
        return false;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RepairableBlockEntity(pos, state);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    static enum BrokenState implements StringRepresentable
    {
        INTACT,
        BROKEN;


        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "intact";
                case 1 -> "broken";
            };
        }
    }
}

