/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot.blocks;

import java.lang.reflect.Method;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.landfall.slipboot.Constants;
import world.landfall.slipboot.Slipboot;
import world.landfall.slipboot.WarpLocations;
import world.landfall.slipboot.blocks.FakeTop;
import world.landfall.slipboot.blocks.RepairableBlock;
import world.landfall.slipboot.blocks.WarpBlockEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WarpBlock
extends RepairableBlock {
    private static final String[] randomNames = new String[]{"Terranova", "New Ides", "Glazov", "Cuidense", "Saludo", "Whimsy"};
    private static WarpLocations locationData = Slipboot.locationData;
    private static Method openWarpScreenMethod = null;
    private static boolean reflectionInitialized = false;
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)32.0, (double)15.0);
    public static final VoxelShape BROKEN_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)21.0, (double)15.0);

    public WarpBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().dynamicShape().explosionResistance(Float.POSITIVE_INFINITY).destroyTime(4.0f), "minecraft:redstone");
    }

    public static void setLocationData(WarpLocations locations) {
        locationData = locations;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide()) {
            locationData.addLocation(randomNames[(int)(Math.random() * (double)randomNames.length)], pos, state.getValue((Property)brokenState) == RepairableBlock.BrokenState.INTACT, level.dimension().location().toString());
        }
        if (level.getBlockState(pos.above()).is((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)"minecraft:air")))) {
            level.setBlock(pos.above(), ((Block)BuiltInRegistries.BLOCK.get(Constants.modResource("fake_top"))).defaultBlockState(), 2);
        }
        Slipboot.LOGGER.info("Warp at " + pos.toString() + " created.");
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        super.destroy(level, pos, state);
        if (locationData != null && !level.isClientSide()) {
            locationData.removeLocation(locationData.getId(pos));
        }
        if (level.getBlockState(pos.above()).is((Block)BuiltInRegistries.BLOCK.get(Constants.modResource("fake_top")))) {
            level.setBlock(pos.above(), ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)"minecraft:air"))).defaultBlockState(), 2);
        }
        Slipboot.LOGGER.info("Warp at {} removed.", (Object)pos.toString());
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean destroyed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (!destroyed) {
            if (locationData != null && !level.isClientSide()) {
                locationData.setActive(locationData.getId(pos), false);
            }
            if (level.getBlockState(pos.above()).is((Block)BuiltInRegistries.BLOCK.get(Constants.modResource("fake_top")))) {
                level.setBlock(pos.above(), (BlockState)((Block)BuiltInRegistries.BLOCK.get(Constants.modResource("fake_top"))).defaultBlockState().setValue(FakeTop.brokenState, (Comparable)((Object)FakeTop.BrokenState.BROKEN)), 2);
            }
            Slipboot.LOGGER.info("Warp at {} broken.", (Object)pos.toString());
        }
        return destroyed;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        RepairableBlock.BrokenState brokenState = (RepairableBlock.BrokenState)((Object)state.getValue(RepairableBlock.brokenState));
        if (brokenState == RepairableBlock.BrokenState.INTACT) {
            if (level.isClientSide()) {
                Slipboot.LOGGER.info("useWithoutItem: Attempting to open warp screen for pos: " + String.valueOf(pos));
                WarpBlock.openClientScreen(pos, player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        RepairableBlock.BrokenState brokenState = (RepairableBlock.BrokenState)((Object)state.getValue(RepairableBlock.brokenState));
        if (brokenState == RepairableBlock.BrokenState.INTACT && stack.is((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"minecraft:name_tag")))) {
            Component customName;
            if (locationData != null && !level.isClientSide() && (customName = (Component)stack.getComponents().get(DataComponents.CUSTOM_NAME)) != null) {
                String newName = Constants.sanitizeName(customName.getString());
                if (!newName.isEmpty()) {
                    locationData.setName(locationData.getId(pos), newName);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    if (level.getBlockState(pos.above()).is((Block)BuiltInRegistries.BLOCK.get(Constants.modResource("fake_top")))) {
                        BlockState fakeTopState = level.getBlockState(pos.above());
                        level.setBlock(pos.above(), (BlockState)fakeTopState.setValue(FakeTop.brokenState, (Comparable)((Object)FakeTop.BrokenState.INTACT)), 2);
                    }
                    Slipboot.LOGGER.info("Warp at {} renamed to: {}", (Object)pos, (Object)newName);
                } else {
                    Slipboot.LOGGER.warn("Invalid warp name provided (empty after sanitization)");
                }
            }
            player.swing(hand);
            return ItemInteractionResult.CONSUME;
        }
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        switch (result) {
            case PASS_TO_DEFAULT_BLOCK_INTERACTION: {
                if (brokenState != RepairableBlock.BrokenState.INTACT) break;
                if (level.isClientSide()) {
                    Slipboot.LOGGER.info("Attempting to open warp screen for pos: " + String.valueOf(pos));
                    WarpBlock.openClientScreen(pos, player);
                }
                player.swing(hand);
                return ItemInteractionResult.CONSUME;
            }
            case SUCCESS: {
                if (!level.isClientSide()) {
                    locationData.setActive(locationData.getId(pos), true);
                }
                if (level.getBlockState(pos.above()).is((Block)BuiltInRegistries.BLOCK.get(Constants.modResource("fake_top")))) {
                    level.setBlock(pos.above(), ((Block)BuiltInRegistries.BLOCK.get(Constants.modResource("fake_top"))).defaultBlockState(), 2);
                }
                return ItemInteractionResult.CONSUME;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WarpBlockEntity(pos, state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        RepairableBlock.BrokenState brokenState = (RepairableBlock.BrokenState)((Object)state.getValue(RepairableBlock.brokenState));
        return brokenState == RepairableBlock.BrokenState.BROKEN ? BROKEN_SHAPE : SHAPE;
    }

    private static void openClientScreen(BlockPos pos, Player player) {
        if (!reflectionInitialized) {
            try {
                Class<?> clientHelperClass = Class.forName("world.landfall.slipboot.client.ClientHelper");
                openWarpScreenMethod = clientHelperClass.getMethod("openWarpScreen", BlockPos.class, Player.class);
                reflectionInitialized = true;
                Slipboot.LOGGER.debug("ClientHelper reflection cache initialized");
            }
            catch (ClassNotFoundException e) {
                Slipboot.LOGGER.error("ClientHelper class not found", (Throwable)e);
                reflectionInitialized = true;
                return;
            }
            catch (NoSuchMethodException e) {
                Slipboot.LOGGER.error("openWarpScreen method not found", (Throwable)e);
                reflectionInitialized = true;
                return;
            }
        }
        if (openWarpScreenMethod != null) {
            try {
                openWarpScreenMethod.invoke(null, pos, player);
                Slipboot.LOGGER.debug("Successfully opened warp screen at {}", (Object)pos);
            }
            catch (Exception e) {
                Slipboot.LOGGER.error("Failed to open warp screen: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

