/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.HtmlMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import world.landfall.slipboot.Slipboot;

public class BlueMapIntegration {
    private static boolean bluemapAvailable = false;
    public static HashMap<String, MarkerSet> markerSetMap = new HashMap();

    private static String makeHTML(String name, boolean active) {
        return String.format("<div class=\"bm-marker-player\" distance-data=\"near\">\n    <img src=\"assets/%s.png\" alt=\"playerhead\" draggable=\"true\">\n    <div class=\"bm-player-name\">%s</div>\n</div>\n", active ? "warp_intact" : "warp_broken", name);
    }

    public static void addMarker(BlockPos pos, String name, int id, ResourceLocation dimension) {
        BlueMapIntegration.addMarker(pos, name, id, dimension, true);
    }

    public static void init(Iterable<ServerLevel> levels) {
        if (!bluemapAvailable) {
            Slipboot.LOGGER.info("Skipping BlueMap initialization - API not available");
            return;
        }
        try {
            for (ServerLevel x : levels) {
                String dimension = x.dimension().location().toString();
                MarkerSet marker = MarkerSet.builder().label(dimension + " Warps").build();
                markerSetMap.put(dimension + "_warps", marker);
            }
            System.out.println(markerSetMap.keySet());
            BlueMapAPI.onEnable(api -> {
                for (BlueMapMap x : ((BlueMapWorld)api.getWorlds().iterator().next()).getMaps()) {
                    for (String y : markerSetMap.keySet()) {
                        System.out.println(x.getWorld().getId());
                        if (!(x.getWorld().getId().split("#")[1] + "_warps").equals(y)) continue;
                        x.getMarkerSets().put(y, markerSetMap.get(y));
                    }
                }
            });
        }
        catch (Exception e) {
            Slipboot.LOGGER.error("Failed to initialize BlueMap integration", (Throwable)e);
        }
    }

    public static void addMarker(BlockPos pos, String name, int id, ResourceLocation dimension, boolean active) {
        if (!bluemapAvailable) {
            return;
        }
        try {
            System.out.println(dimension.toString() + " " + dimension.getPath());
            markerSetMap.get(String.valueOf(dimension) + "_warps").put("" + id, (Marker)((HtmlMarker.Builder)((HtmlMarker.Builder)HtmlMarker.builder().html(BlueMapIntegration.makeHTML(name.replaceAll("<[^>]*>", ""), active)).label("test")).position(new Vector3d((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5))).build());
        }
        catch (Exception e) {
            Slipboot.LOGGER.error("Failed to add BlueMap marker", (Throwable)e);
        }
    }

    public static void removeMarker(int id, ResourceLocation dimension) {
        if (!bluemapAvailable) {
            return;
        }
        try {
            markerSetMap.get(dimension.toString() + "_warps").remove("" + id);
        }
        catch (Exception e) {
            Slipboot.LOGGER.error("Failed to remove BlueMap marker", (Throwable)e);
        }
    }

    static {
        try {
            Class.forName("de.bluecolored.bluemap.api.BlueMapAPI");
            bluemapAvailable = true;
            Slipboot.LOGGER.info("BlueMap API found, integration enabled");
        }
        catch (ClassNotFoundException e) {
            Slipboot.LOGGER.info("BlueMap API not found, integration disabled");
        }
    }
}

