/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot.networking;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import world.landfall.slipboot.Constants;
import world.landfall.slipboot.Slipboot;

public record WarpPacket(String playerName, Vector3f pos, String dimension) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<WarpPacket> TYPE = new CustomPacketPayload.Type(Constants.modResource("warp_packet"));
    public static final StreamCodec<ByteBuf, WarpPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, WarpPacket::playerName, (StreamCodec)ByteBufCodecs.VECTOR3F, WarpPacket::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, WarpPacket::dimension, WarpPacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @EventBusSubscriber(modid="slipboot", bus=EventBusSubscriber.Bus.MOD)
    public static class PacketHandler {
        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToServer(TYPE, STREAM_CODEC, (warpPacket, iPayloadContext) -> iPayloadContext.enqueueWork(() -> {
                ResourceLocation dimLocation;
                Player player = iPayloadContext.player();
                if (!(player instanceof ServerPlayer)) {
                    Slipboot.LOGGER.warn("Received warp packet from non-server player");
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!serverPlayer.getName().getString().equals(warpPacket.playerName)) {
                    Slipboot.LOGGER.warn("Player {} tried to teleport as {}", (Object)serverPlayer.getName().getString(), (Object)warpPacket.playerName);
                    return;
                }
                try {
                    dimLocation = ResourceLocation.parse((String)warpPacket.dimension);
                }
                catch (Exception e) {
                    Slipboot.LOGGER.warn("Invalid dimension in warp packet: {}", (Object)warpPacket.dimension);
                    return;
                }
                if ((double)Math.abs(warpPacket.pos.x) > 3.0E7 || (double)Math.abs(warpPacket.pos.z) > 3.0E7 || (double)warpPacket.pos.y < -64.0 || (double)warpPacket.pos.y > 320.0) {
                    Slipboot.LOGGER.warn("Invalid coordinates in warp packet: {}", (Object)warpPacket.pos);
                    return;
                }
                if (!serverPlayer.hasPermissions(0)) {
                    Slipboot.LOGGER.warn("Player {} lacks permission to warp", (Object)serverPlayer.getName().getString());
                    return;
                }
                Objects.requireNonNull(serverPlayer.getServer()).getAllLevels().forEach(level -> {
                    if (level.dimension().location().equals((Object)dimLocation)) {
                        Slipboot.LOGGER.info("Teleporting {} to {} at {},{},{}", new Object[]{serverPlayer.getName().getString(), dimLocation, Float.valueOf(warpPacket.pos.x), Float.valueOf(warpPacket.pos.y), Float.valueOf(warpPacket.pos.z)});
                        serverPlayer.teleportTo(level, (double)warpPacket.pos.x, (double)warpPacket.pos.y, (double)warpPacket.pos.z, Set.of(), 0.0f, 0.0f);
                    }
                });
            }));
        }
    }
}

