/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public final class Constants {
    public static final int MAX_WARP_NAME_LENGTH = 50;
    public static final int MAX_PACKET_NAME_LENGTH = 100;
    public static final double MAX_WORLD_COORDINATE = 3.0E7;
    public static final double MIN_Y_COORDINATE = -64.0;
    public static final double MAX_Y_COORDINATE = 320.0;
    public static final String[] DIMENSIONS = new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"};
    public static final int[][] TELEPORT_COSTS = new int[][]{{0, 1, 2}, {1, 0, 3}, {2, 3, 0}};
    public static final String FAKE_TOP_BLOCK = "fake_top";
    public static final String NAME_SANITIZATION_PATTERN = "[<>\"'&]";
    public static final int DEFAULT_PLAYER_PERMISSION_LEVEL = 0;

    private Constants() {
    }

    public static ResourceLocation modResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"slipboot", (String)path);
    }

    public static String limitLength(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        return str.substring(0, Math.min(str.length(), maxLength));
    }

    public static String sanitizeName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        return Constants.limitLength(name.replaceAll(NAME_SANITIZATION_PATTERN, ""), 50);
    }

    public static boolean isValidPosition(BlockPos pos) {
        return (double)Math.abs(pos.getX()) <= 3.0E7 && (double)Math.abs(pos.getZ()) <= 3.0E7 && (double)pos.getY() >= -64.0 && (double)pos.getY() <= 320.0;
    }

    public static int getTeleportCost(String fromDimension, String toDimension) {
        int fromIndex = -1;
        int toIndex = -1;
        for (int i = 0; i < DIMENSIONS.length; ++i) {
            if (DIMENSIONS[i].equals(fromDimension)) {
                fromIndex = i;
            }
            if (!DIMENSIONS[i].equals(toDimension)) continue;
            toIndex = i;
        }
        if (fromIndex >= 0 && toIndex >= 0) {
            return TELEPORT_COSTS[fromIndex][toIndex];
        }
        return 0;
    }
}

