/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot.blocks;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FakeTop
extends Block {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)-16.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape BROKEN_SHAPE = Block.box((double)1.0, (double)-16.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
    static final EnumProperty<BrokenState> brokenState = EnumProperty.create((String)"fake_broken_state", BrokenState.class);

    public FakeTop(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.BLOCK).explosionResistance(Float.POSITIVE_INFINITY).noOcclusion().destroyTime(10.0f));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(brokenState, (Comparable)((Object)BrokenState.INTACT)));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockState warp = level.getBlockState(pos.below());
        boolean destroyed = warp.onDestroyedByPlayer(level, pos.below(), player, willHarvest, fluid);
        if (destroyed) {
            warp.getBlock().destroy((LevelAccessor)level, pos.below(), warp);
        }
        return destroyed;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return level.getBlockState(pos.below()).useItemOn(stack, level, player, hand, hitResult.withPosition(pos.below()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{brokenState});
        super.createBlockStateDefinition(builder);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BrokenState brokenState = (BrokenState)((Object)state.getValue(FakeTop.brokenState));
        return brokenState == BrokenState.BROKEN ? BROKEN_SHAPE : SHAPE;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    static enum BrokenState implements StringRepresentable
    {
        INTACT,
        BROKEN;


        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "intact";
                case 1 -> "broken";
            };
        }
    }
}

