/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import world.landfall.slipboot.Constants;
import world.landfall.slipboot.Slipboot;
import world.landfall.slipboot.WarpLocations;
import world.landfall.slipboot.networking.SyncWarpLocationsPacket;

@OnlyIn(value=Dist.CLIENT)
public class ClientWarpData {
    private static final ConcurrentHashMap<Integer, WarpLocations.WarpLocation> locations = new ConcurrentHashMap();
    private static final int MAX_LOCATIONS = 1000;

    public static Map<Integer, WarpLocations.WarpLocation> getLocations() {
        return new ConcurrentHashMap<Integer, WarpLocations.WarpLocation>(locations);
    }

    public static WarpLocations.WarpLocation getLocation(int id) {
        return locations.get(id);
    }

    public static void clear() {
        locations.clear();
        Slipboot.LOGGER.debug("Cleared client warp data");
    }

    public static void updateAllLocations(List<SyncWarpLocationsPacket.WarpLocationData> newLocations) {
        if (newLocations.size() > 1000) {
            Slipboot.LOGGER.warn("Received {} locations, exceeding max of {}. Truncating.", (Object)newLocations.size(), (Object)1000);
            newLocations = newLocations.subList(0, 1000);
        }
        ClientWarpData.clear();
        for (SyncWarpLocationsPacket.WarpLocationData data : newLocations) {
            if (data.id() < 0 || data.name() == null || data.pos() == null || data.level() == null) continue;
            locations.put(data.id(), new WarpLocations.WarpLocation(Constants.limitLength(data.name(), 100), data.pos(), data.id(), data.active(), data.level()));
        }
        Slipboot.LOGGER.info("Updated client warp data with {} locations", (Object)locations.size());
    }

    public static void addLocation(int id, String name, BlockPos pos, boolean active, String level) {
        if (id < 0 || name == null || pos == null || level == null) {
            Slipboot.LOGGER.warn("Invalid warp location data received: id={}, name={}, pos={}, level={}", new Object[]{id, name, pos, level});
            return;
        }
        if (locations.size() >= 1000 && !locations.containsKey(id)) {
            Slipboot.LOGGER.warn("Cannot add warp location {}: max locations ({}) reached", (Object)id, (Object)1000);
            return;
        }
        String safeName = Constants.limitLength(name, 100);
        locations.put(id, new WarpLocations.WarpLocation(safeName, pos, id, active, level));
        Slipboot.LOGGER.debug("Added/updated warp location {} on client", (Object)id);
    }

    public static void removeLocation(int id) {
        if (locations.remove(id) != null) {
            Slipboot.LOGGER.debug("Removed warp location {} on client", (Object)id);
        }
    }

    public static void updateName(int id, String name) {
        if (name == null) {
            Slipboot.LOGGER.warn("Null name received for warp location {}", (Object)id);
            return;
        }
        locations.compute(id, (key, loc) -> {
            if (loc != null) {
                String safeName = Constants.limitLength(name, 100);
                WarpLocations.WarpLocation newLoc = new WarpLocations.WarpLocation(safeName, loc.pos, loc.id, loc.active, loc.level);
                Slipboot.LOGGER.debug("Updated name for warp location {} on client", (Object)id);
                return newLoc;
            }
            return null;
        });
    }

    public static void updateActive(int id, boolean active) {
        locations.compute(id, (key, loc) -> {
            if (loc != null) {
                WarpLocations.WarpLocation newLoc = new WarpLocations.WarpLocation(loc.name, loc.pos, loc.id, active, loc.level);
                Slipboot.LOGGER.debug("Updated active state for warp location {} on client", (Object)id);
                return newLoc;
            }
            return null;
        });
    }
}

