/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.slipboot.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import world.landfall.slipboot.Constants;
import world.landfall.slipboot.Slipboot;
import world.landfall.slipboot.client.ClientWarpData;

@MethodsReturnNonnullByDefault
public record UpdateWarpLocationPacket(UpdateType updateType, int id, String name, BlockPos pos, boolean active, String level) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateWarpLocationPacket> TYPE = new CustomPacketPayload.Type(Constants.modResource("update_warp_location"));
    public static final StreamCodec<ByteBuf, UpdateType> UPDATE_TYPE_CODEC = new StreamCodec<ByteBuf, UpdateType>(){

        public UpdateType decode(ByteBuf buffer) {
            byte ordinal = buffer.readByte();
            UpdateType[] values = UpdateType.values();
            if (ordinal < 0 || ordinal >= values.length) {
                Slipboot.LOGGER.error("Invalid UpdateType ordinal received: {}", (Object)ordinal);
                return UpdateType.REMOVE;
            }
            return values[ordinal];
        }

        public void encode(ByteBuf buffer, UpdateType value) {
            buffer.writeByte(value.ordinal());
        }
    };
    public static final StreamCodec<ByteBuf, UpdateWarpLocationPacket> STREAM_CODEC = StreamCodec.composite(UPDATE_TYPE_CODEC, UpdateWarpLocationPacket::updateType, (StreamCodec)ByteBufCodecs.VAR_INT, UpdateWarpLocationPacket::id, (StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateWarpLocationPacket::name, (StreamCodec)BlockPos.STREAM_CODEC, UpdateWarpLocationPacket::pos, (StreamCodec)ByteBufCodecs.BOOL, UpdateWarpLocationPacket::active, (StreamCodec)ByteBufCodecs.STRING_UTF8, UpdateWarpLocationPacket::level, UpdateWarpLocationPacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static UpdateWarpLocationPacket createAdd(int id, String name, BlockPos pos, boolean active, String level) {
        return new UpdateWarpLocationPacket(UpdateType.ADD, id, name, pos, active, level);
    }

    public static UpdateWarpLocationPacket createRemove(int id) {
        return new UpdateWarpLocationPacket(UpdateType.REMOVE, id, "", BlockPos.ZERO, false, "");
    }

    public static UpdateWarpLocationPacket createUpdateName(int id, String name) {
        return new UpdateWarpLocationPacket(UpdateType.UPDATE_NAME, id, name, BlockPos.ZERO, false, "");
    }

    public static UpdateWarpLocationPacket createUpdateActive(int id, boolean active) {
        return new UpdateWarpLocationPacket(UpdateType.UPDATE_ACTIVE, id, "", BlockPos.ZERO, active, "");
    }

    public static enum UpdateType {
        ADD,
        REMOVE,
        UPDATE_NAME,
        UPDATE_ACTIVE;

    }

    @EventBusSubscriber(modid="slipboot", bus=EventBusSubscriber.Bus.MOD)
    public static class PacketHandler {
        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToClient(TYPE, STREAM_CODEC, (packet, context) -> context.enqueueWork(() -> {
                if (context.player().level().isClientSide()) {
                    switch (packet.updateType().ordinal()) {
                        case 0: {
                            ClientWarpData.addLocation(packet.id(), packet.name(), packet.pos(), packet.active(), packet.level());
                            break;
                        }
                        case 1: {
                            ClientWarpData.removeLocation(packet.id());
                            break;
                        }
                        case 2: {
                            ClientWarpData.updateName(packet.id(), packet.name());
                            break;
                        }
                        case 3: {
                            ClientWarpData.updateActive(packet.id(), packet.active());
                        }
                    }
                    Slipboot.LOGGER.debug("Processed {} update for warp location {}", (Object)packet.updateType(), (Object)packet.id());
                }
            }));
        }
    }
}

