#version 120

#include "/settings.glsl"

out vec2 TexCoords;
out vec4 Color;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform int worldTime;
float state;

float smoothTransition(float time) {
    if (time >= 0.0 && time <= 1000.0) return time / 1000.0;
    else if (time < 12000.0) return 1.0;
    else if (time <= 13000.0) return 1.0 - (time - 12000.0) / 1000.0;
    else return 0.0;
}

void main() {
	vec3 pos = (gl_ModelViewMatrix * gl_Vertex).xyz;
    pos = (gbufferModelViewInverse * vec4(pos,1)).xyz;
    gl_Position = gl_ProjectionMatrix * gbufferModelView * vec4(pos,1);
    gl_FogFragCoord = length(pos);
	
	TexCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

	#if NEW_LIGHTING == 0
	vec3 normal = gl_NormalMatrix * gl_Normal;
	normal = (mc_Entity==1.) ? vec3(0,1,0) : (gbufferModelViewInverse * vec4(normal,0)).xyz;
    float light = min(normal.x * normal.x * 0.6f + normal.y * normal.y * 0.25f * (3.0f + normal.y) + normal.z * normal.z * 0.8f, 1.0f);
	#if CLASSIC_NIGHT == 0
	state = smoothTransition(worldTime);
	Color = vec4((gl_Color.rgb * light * state) + (gl_Color.rgb * (1 - state) * 0.85f), gl_Color.a);
	#else
	Color = vec4(gl_Color.rgb * light, gl_Color.a);
	#endif
	#else
	Color = gl_Color;
	#endif
}
