#version 120

#include "/settings.glsl"

in vec2 TexCoords;
in vec2 LightmapCoords;
in vec4 Color;
in vec3 Normal;
uniform int entityId;

uniform sampler2D texture;
uniform vec3 shadowLightPosition;
uniform vec4 entityColor;

uniform mat4 gbufferModelViewInverse;

void main(){
    vec4 albedo = texture2D(texture, TexCoords) * Color;
	albedo.rgb = mix(albedo.rgb, entityColor.rgb, entityColor.a);
	vec3 shadowLightDir = normalize(mat3(gbufferModelViewInverse) * shadowLightPosition);
	float diffuseLight = 0.0f;
	
	diffuseLight = clamp(dot(shadowLightDir, Normal), 0.0f, 1.0f);
	
	if (int(entityId) == 1) {
		diffuseLight = 1;
	}
	
    /* DRAWBUFFERS:02 */
    gl_FragData[0] = albedo;
    gl_FragData[1] = vec4(LightmapCoords, diffuseLight, 1.0f);
}
