#version 120

#include "/settings.glsl"

in vec2 TexCoords;
in vec2 LightmapCoords;
in vec3 foliageColor;
in vec3 Normal;

uniform sampler2D gtexture;
uniform int isEyeInWater;
uniform vec3 shadowLightPosition;

uniform mat4 gbufferModelViewInverse;

void main() {
    vec4 outputColorData = texture2D(gtexture, TexCoords);
	vec3 albedo = outputColorData.rgb * foliageColor;
	float lightBrightness = 0.0f;
	
	vec2 LC = LightmapCoords;
	if(isEyeInWater == 1) {
		LC += vec2(0.2f);
	}
	else if (isEyeInWater == 2) {
		albedo = vec3(0.6, 0.1, 0.0);
	}
	
	vec3 shadowLightDir = normalize(mat3(gbufferModelViewInverse) * shadowLightPosition);
	
	lightBrightness = clamp(dot(shadowLightDir, Normal), 0.0f, 1.0f);

    /* DRAWBUFFERS:02 */
    gl_FragData[0] = vec4(albedo, outputColorData.a);
    gl_FragData[1] = vec4(LC, lightBrightness, 1.0f);
}
