#version 120

out lowp vec2 TexCoords;
out lowp vec4 Color;

vec3 DistortPosition(vec3 p){
    p.xy *= inversesqrt(p.x*p.x + p.y*p.y + 0.01) * 0.909;
    p.z *= 0.5;
    return p;
}

void main(){
    TexCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    Color = gl_Color;
    gl_Position = ftransform();
    gl_Position.xyz = DistortPosition(gl_Position.xyz);
}
