#version 130

//Shader by LoLip_p

#include "/settings.glsl"

varying vec2 TexCoords;

uniform float viewWidth, viewHeight;
uniform sampler2D colortex0;

vec3 calculateBloom(vec2 TexCoords)
{
    vec3 color = texture(colortex4, TexCoords).rgb;
    float brightness = max(max(color.r, color.g), color.b);
    vec3 bloom = max(color - BLOOM_THRESHOLD, 0.0) * BLOOM_INTENSITY;
    return bloom;
}

void main() {
    vec3 color = texture2D(colortex0, TexCoords).rgb;
	
    // Apply bloom
	//vec3 bloomColor = vec3(0.0);
	//#if BLOOM == 1
	//vec2 texelSize = 1.0 / textureSize(colortex4, 0);
    //for (int i = -BLUR_RADIUS; i <= BLUR_RADIUS; ++i) {
    //    bloomColor += calculateBloom(TexCoords + vec2(float(i) * texelSize.x, 0.0));
	//	bloomColor += calculateBloom(TexCoords + vec2(0.0, float(i) * texelSize.y));
    //}
	//bloomColor /= float(2 * BLUR_RADIUS + 1);
	//bloomColor = pow(bloomColor, vec3(1.0f / 2.2f));
    //#endif
    //color += bloomColor;

    // Apply saturation, brightness, and contrast
    float average = (color.r + color.g + color.b) / 3.0;
    color.rgb = mix(vec3(average), color.rgb, SATURATION);
    color.rgb += BRIGHTNESS;
    color.rgb = ((color.rgb - 0.5) * CONTRAST) + 0.5;

    gl_FragColor = vec4(pow(color, vec3(0.8)), 1.0);
}
