/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class ClientConfig {
    public static final ModConfigSpec SPEC;
    public static final Values VALUES;

    private ClientConfig() {
        throw new UnsupportedOperationException("Utility class");
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(Values::new);
        VALUES = (Values)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }

    public static final class Values {
        public final ModConfigSpec.EnumValue<Theme> theme;
        public final ModConfigSpec.DoubleValue scale;
        public final ModConfigSpec.EnumValue<Anchor> anchor;
        public final ModConfigSpec.IntValue offsetX;
        public final ModConfigSpec.IntValue offsetY;
        public final ModConfigSpec.DoubleValue opacity;
        public final ModConfigSpec.IntValue padding;
        public final ModConfigSpec.IntValue cornerRadius;
        public final ModConfigSpec.BooleanValue showRPM;
        public final ModConfigSpec.BooleanValue showStress;
        public final ModConfigSpec.BooleanValue showNodes;
        public final ModConfigSpec.EnumValue<DisplayMode> defaultDisplayMode;
        public final ModConfigSpec.BooleanValue hideInMenus;
        public final ModConfigSpec.BooleanValue onlyWhenHoldingGoggles;
        public final ModConfigSpec.BooleanValue lockTargetPersist;
        public final ModConfigSpec.IntValue sampleEveryTicks;
        public final ModConfigSpec.IntValue maxBfsNodes;
        public final ModConfigSpec.IntValue cacheTtlTicks;
        public final ModConfigSpec.IntValue configVersion;

        Values(ModConfigSpec.Builder builder) {
            builder.comment("UI Appearance Settings").push("ui");
            this.theme = builder.comment("Theme: AUTO (follow system), LIGHT, or DARK").defineEnum("theme", (Enum)Theme.AUTO);
            this.scale = builder.comment("UI scale multiplier (0.5 = 50%, 2.0 = 200%)").defineInRange("scale", 1.0, 0.5, 2.0);
            this.anchor = builder.comment("Overlay anchor position").defineEnum("anchor", (Enum)Anchor.TOP_LEFT);
            this.offsetX = builder.comment("Horizontal offset from anchor (pixels)").defineInRange("offsetX", 10, -1000, 1000);
            this.offsetY = builder.comment("Vertical offset from anchor (pixels)").defineInRange("offsetY", 10, -1000, 1000);
            this.opacity = builder.comment("Background opacity (0.0 = transparent, 1.0 = opaque)").defineInRange("opacity", 0.8, 0.0, 1.0);
            this.padding = builder.comment("Internal padding (pixels)").defineInRange("padding", 8, 0, 32);
            this.cornerRadius = builder.comment("Corner radius for rounded edges (pixels)").defineInRange("cornerRadius", 4, 0, 16);
            builder.pop();
            builder.comment("Content Display Settings").push("content");
            this.showRPM = builder.comment("Show RPM/speed indicator").define("showRPM", true);
            this.showStress = builder.comment("Show stress consumption vs capacity").define("showStress", true);
            this.showNodes = builder.comment("Show network node count").define("showNodes", true);
            this.defaultDisplayMode = builder.comment("Default display mode: COMPACT or EXPANDED").defineEnum("defaultDisplayMode", (Enum)DisplayMode.COMPACT);
            builder.pop();
            builder.comment("Behaviour Settings").push("behaviour");
            this.hideInMenus = builder.comment("Hide overlay when in menus (inventory, pause, etc.)").define("hideInMenus", true);
            this.onlyWhenHoldingGoggles = builder.comment("Only show overlay when holding Engineer's Goggles (requires Create)").define("onlyWhenHoldingGoggles", false);
            this.lockTargetPersist = builder.comment("Persist locked target across game sessions").define("lockTargetPersist", false);
            builder.pop();
            builder.comment("Performance & Optimization").push("perf");
            this.sampleEveryTicks = builder.comment("Sample target data every N ticks (lower = more responsive, higher = better performance)").defineInRange("sampleEveryTicks", 5, 1, 20);
            this.maxBfsNodes = builder.comment("Maximum nodes to scan during BFS network estimation").defineInRange("maxBfsNodes", 256, 16, 2048);
            this.cacheTtlTicks = builder.comment("Cache time-to-live in ticks (20 ticks = 1 second)").defineInRange("cacheTtlTicks", 20, 5, 100);
            builder.pop();
            builder.comment("Internal (do not modify)").push("internal");
            this.configVersion = builder.comment("Config schema version for migration").defineInRange("configVersion", 1, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static enum DisplayMode {
        COMPACT,
        EXPANDED;

    }

    public static enum Anchor {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static enum Theme {
        AUTO,
        LIGHT,
        DARK;

    }
}

