/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.hud;

import com.zivalez.createanalyzerlite.config.ClientConfig;
import com.zivalez.createanalyzerlite.config.ConfigData;

public final class LayoutEngine {
    private static final int COMPACT_BASE_WIDTH = 180;
    private static final int EXPANDED_BASE_WIDTH = 220;

    public static Layout calculate(ConfigData config, int screenWidth, int screenHeight, ClientConfig.DisplayMode mode) {
        int baseWidth;
        int width = baseWidth = mode == ClientConfig.DisplayMode.COMPACT ? 180 : 220;
        int height = 100;
        int anchorX = LayoutEngine.calculateAnchorX(config.anchor(), screenWidth, width, config.scale());
        int anchorY = LayoutEngine.calculateAnchorY(config.anchor(), screenHeight, 100, config.scale());
        int finalX = anchorX + config.offsetX();
        int finalY = anchorY + config.offsetY();
        return new Layout(finalX, finalY, width, 100);
    }

    private static int calculateAnchorX(ClientConfig.Anchor anchor, int screenWidth, int width, double scale) {
        return switch (anchor) {
            default -> throw new MatchException(null, null);
            case ClientConfig.Anchor.TOP_LEFT, ClientConfig.Anchor.BOTTOM_LEFT -> 0;
            case ClientConfig.Anchor.TOP_RIGHT, ClientConfig.Anchor.BOTTOM_RIGHT -> (int)((double)screenWidth - (double)width * scale);
        };
    }

    private static int calculateAnchorY(ClientConfig.Anchor anchor, int screenHeight, int height, double scale) {
        return switch (anchor) {
            default -> throw new MatchException(null, null);
            case ClientConfig.Anchor.TOP_LEFT, ClientConfig.Anchor.TOP_RIGHT -> 0;
            case ClientConfig.Anchor.BOTTOM_LEFT, ClientConfig.Anchor.BOTTOM_RIGHT -> (int)((double)screenHeight - (double)height * scale);
        };
    }

    private LayoutEngine() {
        throw new UnsupportedOperationException("Utility class");
    }

    public record Layout(int x, int y, int width, int height) {
    }
}

