/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zivalez.createanalyzerlite.CreateAnalyzerLite;
import com.zivalez.createanalyzerlite.config.ClientConfig;
import com.zivalez.createanalyzerlite.config.ConfigData;
import com.zivalez.createanalyzerlite.hud.LayoutEngine;
import com.zivalez.createanalyzerlite.hud.Theme;
import com.zivalez.createanalyzerlite.hud.Widgets;
import com.zivalez.createanalyzerlite.integration.create.CreatePresent;
import com.zivalez.createanalyzerlite.integration.create.KineticData;
import com.zivalez.createanalyzerlite.integration.create.KineticQuery;
import com.zivalez.createanalyzerlite.probe.TargetSelector;
import com.zivalez.createanalyzerlite.util.Cache;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public final class OverlayRenderer {
    private static boolean overlayEnabled = true;
    private static ClientConfig.DisplayMode currentMode = ClientConfig.DisplayMode.COMPACT;
    private static final Cache<KineticData> dataCache = new Cache(20);
    private static long lastSampleTick = 0L;
    @Nullable
    private static BlockPos lockedTarget = null;

    @SubscribeEvent
    public static void onRenderGuiLayer(RenderGuiLayerEvent.Post event) {
        if (!event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            return;
        }
        if (!overlayEnabled) {
            return;
        }
        if (!CreatePresent.isLoaded()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        ConfigData config = ConfigData.fromSpec();
        if (config.hideInMenus() && mc.screen != null) {
            return;
        }
        BlockEntity target = OverlayRenderer.getTargetBlockEntity(mc, config);
        if (target == null) {
            return;
        }
        KineticData data = OverlayRenderer.queryKineticData(target, mc, config);
        if (data == null) {
            return;
        }
        OverlayRenderer.renderOverlay(event.getGuiGraphics(), data, config, mc);
    }

    @Nullable
    private static BlockEntity getTargetBlockEntity(Minecraft mc, ConfigData config) {
        if (lockedTarget != null) {
            return mc.level.getBlockEntity(lockedTarget);
        }
        return TargetSelector.getTargetedKineticBlock(mc);
    }

    @Nullable
    private static KineticData queryKineticData(BlockEntity target, Minecraft mc, ConfigData config) {
        long currentTick = mc.level.getGameTime();
        KineticData cached = dataCache.get(currentTick);
        if (cached != null) {
            return cached;
        }
        if (currentTick - lastSampleTick < (long)config.sampleEveryTicks()) {
            return null;
        }
        lastSampleTick = currentTick;
        KineticData fresh = KineticQuery.query(target, config);
        if (fresh != null) {
            dataCache.put(fresh, currentTick);
        }
        return fresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void renderOverlay(GuiGraphics gfx, KineticData data, ConfigData config, Minecraft mc) {
        PoseStack pose = gfx.pose();
        pose.pushPose();
        try {
            Theme theme = Theme.fromConfig(config);
            LayoutEngine.Layout layout = LayoutEngine.calculate(config, mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight(), currentMode);
            pose.translate((float)layout.x(), (float)layout.y(), 0.0f);
            pose.scale((float)config.scale(), (float)config.scale(), 1.0f);
            switch (currentMode) {
                case COMPACT: {
                    OverlayRenderer.renderCompact(gfx, data, config, theme, layout);
                    return;
                }
                case EXPANDED: {
                    OverlayRenderer.renderExpanded(gfx, data, config, theme, layout);
                    return;
                }
            }
            return;
        }
        finally {
            pose.popPose();
        }
    }

    private static void renderCompact(GuiGraphics gfx, KineticData data, ConfigData config, Theme theme, LayoutEngine.Layout layout) {
        int yOffset = 0;
        int panelHeight = OverlayRenderer.calculateCompactHeight(config);
        Widgets.drawPanel(gfx, 0, 0, layout.width(), panelHeight, theme, config);
        yOffset += config.padding();
        if (config.showRPM()) {
            String rpmText = String.format("\u2699 %.1f RPM", Float.valueOf(Math.abs(data.speed())));
            Widgets.drawText(gfx, rpmText, config.padding(), yOffset, theme.textColor());
            yOffset += 12;
        }
        if (config.showStress()) {
            int barY = yOffset;
            int barWidth = layout.width() - config.padding() * 2;
            Widgets.drawStressBar(gfx, config.padding(), barY, barWidth, 6, data, theme);
            yOffset += 10;
        }
        if (config.showNodes()) {
            String nodeText = data.nodesApproximate() ? String.format("\u2248%d nodes", data.nodes()) : String.format("%d nodes", data.nodes());
            Widgets.drawText(gfx, nodeText, config.padding(), yOffset, theme.mutedColor());
        }
    }

    private static void renderExpanded(GuiGraphics gfx, KineticData data, ConfigData config, Theme theme, LayoutEngine.Layout layout) {
        int yOffset = 0;
        int panelHeight = OverlayRenderer.calculateExpandedHeight(config);
        Widgets.drawPanel(gfx, 0, 0, layout.width(), panelHeight, theme, config);
        Widgets.drawText(gfx, "Create Metrics", config.padding(), yOffset += config.padding(), theme.titleColor());
        yOffset += 14;
        if (config.showRPM()) {
            Widgets.drawLabel(gfx, "Speed:", config.padding(), yOffset, theme);
            String rpmValue = String.format("%.1f RPM %s", Float.valueOf(Math.abs(data.speed())), data.speed() > 0.0f ? "\u27f3" : "\u27f2");
            Widgets.drawText(gfx, rpmValue, config.padding() + 50, yOffset, theme.valueColor());
            yOffset += 14;
        }
        if (config.showStress()) {
            Widgets.drawLabel(gfx, "Stress:", config.padding(), yOffset, theme);
            int barWidth = layout.width() - config.padding() * 2;
            Widgets.drawStressBar(gfx, config.padding(), yOffset += 12, barWidth, 8, data, theme);
            String stressText = data.stressApproximate() ? String.format("\u2248%.1f / %.1f", data.stressConsumption(), data.stressCapacity()) : String.format("%.1f / %.1f", data.stressConsumption(), data.stressCapacity());
            Widgets.drawText(gfx, stressText, config.padding(), yOffset += 12, theme.mutedColor());
            yOffset += 14;
        }
        if (config.showNodes()) {
            Widgets.drawLabel(gfx, "Network:", config.padding(), yOffset, theme);
            String nodeText = data.nodesApproximate() ? String.format("\u2248%d nodes", data.nodes()) : String.format("%d nodes", data.nodes());
            Widgets.drawText(gfx, nodeText, config.padding() + 60, yOffset, theme.valueColor());
            yOffset += 14;
        }
        if (lockedTarget != null) {
            Widgets.drawText(gfx, "\ud83d\udd12 Locked", config.padding(), yOffset, theme.accentColor());
        }
    }

    private static int calculateCompactHeight(ConfigData config) {
        int height = config.padding() * 2;
        if (config.showRPM()) {
            height += 12;
        }
        if (config.showStress()) {
            height += 10;
        }
        if (config.showNodes()) {
            height += 12;
        }
        return height;
    }

    private static int calculateExpandedHeight(ConfigData config) {
        int height = config.padding() * 2 + 14;
        if (config.showRPM()) {
            height += 14;
        }
        if (config.showStress()) {
            height += 38;
        }
        if (config.showNodes()) {
            height += 14;
        }
        if (lockedTarget != null) {
            height += 14;
        }
        return height;
    }

    public static void toggleOverlay() {
        overlayEnabled = !overlayEnabled;
        CreateAnalyzerLite.LOGGER.info("Overlay: {}", (Object)(overlayEnabled ? "ON" : "OFF"));
    }

    public static void cycleMode() {
        currentMode = currentMode == ClientConfig.DisplayMode.COMPACT ? ClientConfig.DisplayMode.EXPANDED : ClientConfig.DisplayMode.COMPACT;
        CreateAnalyzerLite.LOGGER.debug("Display mode: {}", (Object)currentMode);
    }

    public static void toggleLock() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (lockedTarget != null) {
            lockedTarget = null;
            CreateAnalyzerLite.LOGGER.info("Target unlocked");
        } else {
            BlockEntity target = TargetSelector.getTargetedKineticBlock(mc);
            if (target != null) {
                lockedTarget = target.getBlockPos();
                CreateAnalyzerLite.LOGGER.info("Target locked: {}", (Object)lockedTarget);
            }
        }
    }

    private OverlayRenderer() {
        throw new UnsupportedOperationException("Utility class");
    }
}

