/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.hud;

import com.zivalez.createanalyzerlite.config.ClientConfig;
import com.zivalez.createanalyzerlite.config.ConfigData;
import com.zivalez.createanalyzerlite.util.ColorUtil;

public sealed interface Theme {
    public int backgroundColor();

    public int titleColor();

    public int textColor();

    public int mutedColor();

    public int valueColor();

    public int accentColor();

    public int stressSafeColor();

    public int stressWarningColor();

    public int stressDangerColor();

    public static Theme fromConfig(ConfigData config) {
        return switch (config.theme()) {
            default -> throw new MatchException(null, null);
            case ClientConfig.Theme.LIGHT -> new LightTheme(config.opacity());
            case ClientConfig.Theme.DARK -> new DarkTheme(config.opacity());
            case ClientConfig.Theme.AUTO -> Theme.detectSystemTheme(config.opacity());
        };
    }

    private static Theme detectSystemTheme(double opacity) {
        return new DarkTheme(opacity);
    }

    public static final class LightTheme
    implements Theme {
        private final double opacity;

        public LightTheme(double opacity) {
            this.opacity = opacity;
        }

        @Override
        public int backgroundColor() {
            return ColorUtil.withAlpha(0xF0F0F0, this.opacity);
        }

        @Override
        public int titleColor() {
            return -13877680;
        }

        @Override
        public int textColor() {
            return -13350562;
        }

        @Override
        public int mutedColor() {
            return -8418163;
        }

        @Override
        public int valueColor() {
            return -14057287;
        }

        @Override
        public int accentColor() {
            return -7453523;
        }

        @Override
        public int stressSafeColor() {
            return -14176672;
        }

        @Override
        public int stressWarningColor() {
            return -812014;
        }

        @Override
        public int stressDangerColor() {
            return -1618884;
        }
    }

    public static final class DarkTheme
    implements Theme {
        private final double opacity;

        public DarkTheme(double opacity) {
            this.opacity = opacity;
        }

        @Override
        public int backgroundColor() {
            return ColorUtil.withAlpha(0x1E1E1E, this.opacity);
        }

        @Override
        public int titleColor() {
            return -1249039;
        }

        @Override
        public int textColor() {
            return -4340793;
        }

        @Override
        public int mutedColor() {
            return -8418163;
        }

        @Override
        public int valueColor() {
            return -13330213;
        }

        @Override
        public int accentColor() {
            return -6596170;
        }

        @Override
        public int stressSafeColor() {
            return -13710223;
        }

        @Override
        public int stressWarningColor() {
            return -932849;
        }

        @Override
        public int stressDangerColor() {
            return -1618884;
        }
    }
}

