/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.hud;

import com.zivalez.createanalyzerlite.config.ConfigData;
import com.zivalez.createanalyzerlite.hud.Theme;
import com.zivalez.createanalyzerlite.integration.create.KineticData;
import com.zivalez.createanalyzerlite.util.ColorUtil;
import com.zivalez.createanalyzerlite.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public final class Widgets {
    public static void drawPanel(GuiGraphics gfx, int x, int y, int width, int height, Theme theme, ConfigData config) {
        gfx.fill(x, y, x + width, y + height, theme.backgroundColor());
        int borderColor = ColorUtil.withAlpha(theme.textColor(), 0.2);
        gfx.fill(x, y, x + width, y + 1, borderColor);
        gfx.fill(x, y + height - 1, x + width, y + height, borderColor);
        gfx.fill(x, y, x + 1, y + height, borderColor);
        gfx.fill(x + width - 1, y, x + width, y + height, borderColor);
    }

    public static void drawStressBar(GuiGraphics gfx, int x, int y, int width, int height, KineticData data, Theme theme) {
        float ratio = data.stressCapacity() > 0.0 ? (float)(data.stressConsumption() / data.stressCapacity()) : 0.0f;
        float clampedRatio = MathUtil.clamp(ratio, 0.0f, 1.0f);
        int fillWidth = (int)((float)width * clampedRatio);
        int bgColor = ColorUtil.withAlpha(theme.textColor(), 0.2);
        gfx.fill(x, y, x + width, y + height, bgColor);
        int fillColor = Widgets.getStressColor(clampedRatio, theme);
        if (fillWidth > 0) {
            gfx.fill(x, y, x + fillWidth, y + height, fillColor);
        }
    }

    private static int getStressColor(float ratio, Theme theme) {
        if (ratio < 0.7f) {
            return theme.stressSafeColor();
        }
        if (ratio < 0.9f) {
            return theme.stressWarningColor();
        }
        return theme.stressDangerColor();
    }

    public static void drawText(GuiGraphics gfx, String text, int x, int y, int color) {
        Minecraft mc = Minecraft.getInstance();
        gfx.drawString(mc.font, text, x, y, color, false);
    }

    public static void drawLabel(GuiGraphics gfx, String label, int x, int y, Theme theme) {
        Widgets.drawText(gfx, label, x, y, theme.mutedColor());
    }

    public static void drawBadge(GuiGraphics gfx, String text, int x, int y, int bgColor, int textColor) {
        Minecraft mc = Minecraft.getInstance();
        int textWidth = mc.font.width(text);
        int badgeWidth = textWidth + 8;
        int badgeHeight = 12;
        gfx.fill(x, y, x + badgeWidth, y + 12, bgColor);
        gfx.drawString(mc.font, text, x + 4, y + 2, textColor, false);
    }

    public static void drawIcon(GuiGraphics gfx, String icon, int x, int y, int color) {
        Widgets.drawText(gfx, icon, x, y, color);
    }

    private Widgets() {
        throw new UnsupportedOperationException("Utility class");
    }
}

