/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.zivalez.createanalyzerlite.CreateAnalyzerLite;
import com.zivalez.createanalyzerlite.hud.OverlayRenderer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public final class Keybinds {
    private static final String CATEGORY = "key.categories.createanalyzerlite";
    public static final KeyMapping TOGGLE_OVERLAY = new KeyMapping("key.createanalyzerlite.toggle_overlay", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 79, "key.categories.createanalyzerlite");
    public static final KeyMapping CYCLE_MODE = new KeyMapping("key.createanalyzerlite.cycle_mode", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 79, "key.categories.createanalyzerlite");
    public static final KeyMapping LOCK_TARGET = new KeyMapping("key.createanalyzerlite.lock_target", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 79, "key.categories.createanalyzerlite");

    public static void register(RegisterKeyMappingsEvent event) {
        event.register(TOGGLE_OVERLAY);
        event.register(CYCLE_MODE);
        event.register(LOCK_TARGET);
        CreateAnalyzerLite.LOGGER.debug("Registered {} keybinds", (Object)3);
        NeoForge.EVENT_BUS.addListener(Keybinds::onClientLevelTickEnd);
    }

    private static void onClientLevelTickEnd(LevelTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (!event.getLevel().isClientSide()) {
            return;
        }
        if (mc.player == null) {
            return;
        }
        while (TOGGLE_OVERLAY.consumeClick()) {
            OverlayRenderer.toggleOverlay();
        }
        while (CYCLE_MODE.consumeClick()) {
            OverlayRenderer.cycleMode();
        }
        while (LOCK_TARGET.consumeClick()) {
            OverlayRenderer.toggleLock();
        }
    }

    private Keybinds() {
        throw new UnsupportedOperationException("Utility class");
    }
}

