/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.integration.create;

import com.zivalez.createanalyzerlite.CreateAnalyzerLite;
import com.zivalez.createanalyzerlite.config.ConfigData;
import com.zivalez.createanalyzerlite.integration.create.CreatePresent;
import com.zivalez.createanalyzerlite.integration.create.KineticData;
import com.zivalez.createanalyzerlite.integration.create.NetworkEstimator;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class KineticQuery {
    private static final String KINETIC_BE_CLASS = "com.simibubi.create.content.kinetics.base.KineticBlockEntity";

    @Nullable
    public static KineticData query(BlockEntity be, ConfigData config) {
        if (!CreatePresent.isLoaded()) {
            return null;
        }
        try {
            Class<?> kineticClass = Class.forName(KINETIC_BE_CLASS);
            if (!kineticClass.isInstance(be)) {
                return null;
            }
            float speed = KineticQuery.getSpeed(be, kineticClass);
            StressData stress = KineticQuery.getStressData(be, kineticClass, config);
            return new KineticData(speed, stress.consumption(), stress.capacity(), stress.nodes(), stress.approximate(), stress.approximate());
        }
        catch (Exception e) {
            CreateAnalyzerLite.LOGGER.debug("Failed to query kinetic data: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static float getSpeed(BlockEntity be, Class<?> kineticClass) throws Exception {
        Field speedField = kineticClass.getDeclaredField("speed");
        speedField.setAccessible(true);
        return speedField.getFloat(be);
    }

    private static StressData getStressData(BlockEntity be, Class<?> kineticClass, ConfigData config) {
        try {
            Minecraft mc = Minecraft.getInstance();
            return NetworkEstimator.estimate(be, (Level)mc.level, config);
        }
        catch (Exception e) {
            CreateAnalyzerLite.LOGGER.debug("Network query failed, using estimator: {}", (Object)e.getMessage());
            Minecraft mc = Minecraft.getInstance();
            return NetworkEstimator.estimate(be, (Level)mc.level, config);
        }
    }

    private KineticQuery() {
        throw new UnsupportedOperationException("Utility class");
    }

    record StressData(double consumption, double capacity, int nodes, boolean approximate) {
    }
}

