/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.integration.create;

import com.zivalez.createanalyzerlite.CreateAnalyzerLite;
import com.zivalez.createanalyzerlite.config.ConfigData;
import com.zivalez.createanalyzerlite.integration.create.KineticQuery;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class NetworkEstimator {
    private static final String KINETIC_BE_CLASS = "com.simibubi.create.content.kinetics.base.KineticBlockEntity";

    public static KineticQuery.StressData estimate(BlockEntity startBe, Level level, ConfigData config) {
        boolean capped;
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(startBe.getBlockPos());
        visited.add(startBe.getBlockPos());
        int nodeCount = 0;
        double estimatedConsumption = 0.0;
        double estimatedCapacity = 0.0;
        int maxNodes = config.maxBfsNodes();
        while (!queue.isEmpty() && nodeCount < maxNodes) {
            BlockPos current = (BlockPos)queue.poll();
            ++nodeCount;
            BlockEntity be = level.getBlockEntity(current);
            if (be != null && NetworkEstimator.isKineticBlock(be)) {
                StressContribution contrib = NetworkEstimator.estimateBlockStress(be);
                estimatedConsumption += contrib.consumption();
                estimatedCapacity += contrib.capacity();
            }
            for (Direction dir : Direction.values()) {
                BlockEntity neighborBe;
                BlockPos neighbor = current.relative(dir);
                if (visited.contains(neighbor) || (neighborBe = level.getBlockEntity(neighbor)) == null || !NetworkEstimator.isKineticBlock(neighborBe)) continue;
                queue.add(neighbor);
                visited.add(neighbor);
            }
        }
        boolean bl = capped = nodeCount >= maxNodes;
        if (capped) {
            CreateAnalyzerLite.LOGGER.debug("BFS capped at {} nodes", (Object)maxNodes);
        }
        return new KineticQuery.StressData(estimatedConsumption, estimatedCapacity, nodeCount, true);
    }

    private static boolean isKineticBlock(BlockEntity be) {
        try {
            Class<?> kineticClass = Class.forName(KINETIC_BE_CLASS);
            return kineticClass.isInstance(be);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static StressContribution estimateBlockStress(BlockEntity be) {
        String blockName = be.getBlockState().getBlock().getDescriptionId();
        if (blockName.contains("motor")) {
            return new StressContribution(0.0, 256.0);
        }
        if (blockName.contains("fan") || blockName.contains("press")) {
            return new StressContribution(16.0, 0.0);
        }
        if (blockName.contains("furnace")) {
            return new StressContribution(32.0, 0.0);
        }
        return new StressContribution(0.0, 0.0);
    }

    private NetworkEstimator() {
        throw new UnsupportedOperationException("Utility class");
    }

    private record StressContribution(double consumption, double capacity) {
    }
}

