/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.probe;

import com.zivalez.createanalyzerlite.integration.create.CreatePresent;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public final class TargetSelector {
    private static final String KINETIC_BE_CLASS = "com.simibubi.create.content.kinetics.base.KineticBlockEntity";
    private static final double MAX_REACH_DISTANCE = 20.0;

    @Nullable
    public static BlockEntity getTargetedKineticBlock(Minecraft mc) {
        if (!CreatePresent.isLoaded()) {
            return null;
        }
        if (mc.player == null || mc.level == null) {
            return null;
        }
        HitResult hitResult = mc.hitResult;
        if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        BlockPos pos = blockHit.getBlockPos();
        if (mc.player.position().distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > 400.0) {
            return null;
        }
        BlockEntity be = mc.level.getBlockEntity(pos);
        if (be == null) {
            return null;
        }
        if (!TargetSelector.isKineticBlock(be)) {
            return null;
        }
        return be;
    }

    private static boolean isKineticBlock(BlockEntity be) {
        try {
            Class<?> kineticClass = Class.forName(KINETIC_BE_CLASS);
            return kineticClass.isInstance(be);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private TargetSelector() {
        throw new UnsupportedOperationException("Utility class");
    }
}

