/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.util;

import javax.annotation.Nullable;

public final class Cache<T> {
    private final int ttlTicks;
    @Nullable
    private T value;
    private long expiryTick;

    public Cache(int ttlTicks) {
        if (ttlTicks < 1) {
            throw new IllegalArgumentException("TTL must be >= 1 tick");
        }
        this.ttlTicks = ttlTicks;
        this.expiryTick = -1L;
    }

    @Nullable
    public T get(long currentTick) {
        if (currentTick < this.expiryTick) {
            return this.value;
        }
        return null;
    }

    public void put(@Nullable T value, long currentTick) {
        this.value = value;
        this.expiryTick = currentTick + (long)this.ttlTicks;
    }

    public void invalidate() {
        this.value = null;
        this.expiryTick = -1L;
    }

    public boolean isValid(long currentTick) {
        return currentTick < this.expiryTick && this.value != null;
    }
}

