/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.util;

import com.zivalez.createanalyzerlite.util.MathUtil;

public final class ColorUtil {
    public static int withAlpha(int rgb, double alpha) {
        int a = (int)(MathUtil.clamp(alpha, 0.0, 1.0) * 255.0);
        return a << 24 | rgb & 0xFFFFFF;
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int getBlue(int argb) {
        return argb & 0xFF;
    }

    public static int argb(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int blend(int color1, int color2, float t) {
        float t1 = 1.0f - t;
        int a = (int)((float)ColorUtil.getAlpha(color1) * t1 + (float)ColorUtil.getAlpha(color2) * t);
        int r = (int)((float)ColorUtil.getRed(color1) * t1 + (float)ColorUtil.getRed(color2) * t);
        int g = (int)((float)ColorUtil.getGreen(color1) * t1 + (float)ColorUtil.getGreen(color2) * t);
        int b = (int)((float)ColorUtil.getBlue(color1) * t1 + (float)ColorUtil.getBlue(color2) * t);
        return ColorUtil.argb(r, g, b, a);
    }

    public static int darken(int color, float factor) {
        float f = MathUtil.clamp(factor, 0.0f, 1.0f);
        int a = ColorUtil.getAlpha(color);
        int r = (int)((float)ColorUtil.getRed(color) * f);
        int g = (int)((float)ColorUtil.getGreen(color) * f);
        int b = (int)((float)ColorUtil.getBlue(color) * f);
        return ColorUtil.argb(r, g, b, a);
    }

    public static int lighten(int color, float factor) {
        float f = MathUtil.clamp(factor, 0.0f, 1.0f);
        int a = ColorUtil.getAlpha(color);
        int r = (int)((float)ColorUtil.getRed(color) + (float)(255 - ColorUtil.getRed(color)) * f);
        int g = (int)((float)ColorUtil.getGreen(color) + (float)(255 - ColorUtil.getGreen(color)) * f);
        int b = (int)((float)ColorUtil.getBlue(color) + (float)(255 - ColorUtil.getBlue(color)) * f);
        return ColorUtil.argb(r, g, b, a);
    }

    private ColorUtil() {
        throw new UnsupportedOperationException("Utility class");
    }
}

