/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.util;

public final class MathUtil {
    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static int sign(float value) {
        if (value > 0.0f) {
            return 1;
        }
        if (value < 0.0f) {
            return -1;
        }
        return 0;
    }

    public static int sign(double value) {
        if (value > 0.0) {
            return 1;
        }
        if (value < 0.0) {
            return -1;
        }
        return 0;
    }

    public static boolean isZero(float value, float epsilon) {
        return Math.abs(value) < epsilon;
    }

    public static boolean approxEqual(float a, float b, float epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    private MathUtil() {
        throw new UnsupportedOperationException("Utility class");
    }
}

