/*
 * Decompiled with CFR 0.152.
 */
package com.zivalez.createanalyzerlite.util;

public final class TextUtil {
    public static String formatCompact(double value) {
        double abs = Math.abs(value);
        if (abs >= 1.0E9) {
            return String.format("%.1fB", value / 1.0E9);
        }
        if (abs >= 1000000.0) {
            return String.format("%.1fM", value / 1000000.0);
        }
        if (abs >= 1000.0) {
            return String.format("%.1fK", value / 1000.0);
        }
        return String.format("%.0f", value);
    }

    public static String formatRPM(float rpm) {
        String direction = rpm >= 0.0f ? "\u27f3" : "\u27f2";
        return String.format("%.1f RPM %s", Float.valueOf(Math.abs(rpm)), direction);
    }

    public static String formatPercent(double value) {
        return String.format("%.0f%%", value * 100.0);
    }

    public static String formatDecimal(double value, int decimals) {
        return String.format("%%.%df".formatted(decimals), value);
    }

    public static String truncate(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        return text.substring(0, maxLength - 3) + "...";
    }

    public static String padLeft(String text, int width) {
        return String.format("%" + width + "s", text);
    }

    public static String padRight(String text, int width) {
        return String.format("%-" + width + "s", text);
    }

    private TextUtil() {
        throw new UnsupportedOperationException("Utility class");
    }
}

