/*
 * Decompiled with CFR 0.152.
 */
package com.example.creepernerfplus;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="creepernerfplus")
public final class CreeperNerfPlusEvents {
    private CreeperNerfPlusEvents() {
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        if (!(target instanceof Player)) {
            return;
        }
        DamageSource source = event.getSource();
        if (!source.is(DamageTypeTags.IS_EXPLOSION)) {
            return;
        }
        Entity direct = source.getDirectEntity();
        if (!(direct instanceof Creeper)) {
            return;
        }
        float current = event.getNewDamage();
        event.setNewDamage(current / 2.0f);
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            creeper.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)creeper, Player.class, 10.0f, 1.0, 1.25, living -> {
                Player player;
                return living instanceof Player && CreeperNerfPlusEvents.playerHasTorch(player = (Player)living);
            }));
        }
    }

    private static boolean playerHasTorch(Player player) {
        return CreeperNerfPlusEvents.isTorchItem(player.getMainHandItem()) || CreeperNerfPlusEvents.isTorchItem(player.getOffhandItem());
    }

    private static boolean isTorchItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.is(Items.TORCH) || stack.is(Items.SOUL_TORCH);
    }
}

