/*
 * Decompiled with CFR 0.152.
 */
package com.example.creepernerfplus;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="creepernerfplus")
public class TorchLightHandler {
    private static final Map<UUID, BlockPos> LAST_LIGHT_POS = new HashMap<UUID, BlockPos>();

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        BlockState current;
        BlockState oldState;
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        UUID id = player.getUUID();
        boolean hasTorchInHand = TorchLightHandler.hasTorchInHand(player);
        BlockPos oldPos = LAST_LIGHT_POS.get(id);
        if (!hasTorchInHand) {
            if (oldPos != null) {
                BlockState oldState2 = level.getBlockState(oldPos);
                if (oldState2.is(Blocks.LIGHT)) {
                    level.setBlock(oldPos, Blocks.AIR.defaultBlockState(), 3);
                }
                LAST_LIGHT_POS.remove(id);
            }
            return;
        }
        BlockPos bestPos = TorchLightHandler.findBestLightPos(level, player);
        if (bestPos == null) {
            return;
        }
        if (oldPos != null && oldPos.equals((Object)bestPos)) {
            return;
        }
        if (oldPos != null && (oldState = level.getBlockState(oldPos)).is(Blocks.LIGHT)) {
            level.setBlock(oldPos, Blocks.AIR.defaultBlockState(), 3);
        }
        if ((current = level.getBlockState(bestPos)).isAir() || current.is(Blocks.LIGHT)) {
            BlockState lightState = (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(15));
            level.setBlock(bestPos, lightState, 3);
            LAST_LIGHT_POS.put(id, bestPos.immutable());
        }
    }

    private static BlockPos findBestLightPos(ServerLevel level, Player player) {
        BlockPos center = player.blockPosition();
        int radius = 1;
        BlockPos best = null;
        for (int dy = 0; dy <= 2; ++dy) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = center.offset(dx, dy, dz);
                    BlockState state = level.getBlockState(pos);
                    if (!state.isAir() && !state.is(Blocks.LIGHT)) continue;
                    return pos.immutable();
                }
            }
        }
        return best;
    }

    private static boolean hasTorchInHand(Player player) {
        return TorchLightHandler.isTorchItem(player.getMainHandItem()) || TorchLightHandler.isTorchItem(player.getOffhandItem());
    }

    private static boolean isTorchItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return stack.is(Items.TORCH) || stack.is(Items.SOUL_TORCH);
    }
}

