/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.item;

import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.misc.DirectionSelector;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import dev.quarris.ppfluids.container.FluidRetrievalContainer;
import dev.quarris.ppfluids.item.FluidItem;
import dev.quarris.ppfluids.item.FluidModuleItem;
import dev.quarris.ppfluids.item.IFluidFilterProvider;
import dev.quarris.ppfluids.misc.FluidDirectionSelector;
import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import dev.quarris.ppfluids.pipenetwork.FluidNetworkLocation;
import dev.quarris.ppfluids.pipenetwork.PipeNetworkUtil;
import dev.quarris.ppfluids.registry.MenuSetup;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidRetrievalModuleItem
extends FluidModuleItem
implements IFluidFilterProvider {
    private final int maxExtraction;
    private final int speed;
    private final boolean preventOversending;
    public final int filterSlots;

    public FluidRetrievalModuleItem(String name, ModuleTier tier, Item.Properties properties) {
        super(name, properties);
        this.maxExtraction = (Integer)tier.forTier((Object)500, (Object)2000, (Object)8000);
        this.speed = (Integer)tier.forTier((Object)40, (Object)20, (Object)10);
        this.filterSlots = (Integer)tier.forTier((Object)2, (Object)4, (Object)8);
        this.preventOversending = true;
    }

    public void tick(ItemStack module, PipeBlockEntity tile) {
        FluidPipeBlockEntity fluidPipe;
        block5: {
            block4: {
                if (!(tile instanceof FluidPipeBlockEntity)) break block4;
                fluidPipe = (FluidPipeBlockEntity)tile;
                if (tile.shouldWorkNow(this.speed) && tile.canWork()) break block5;
            }
            return;
        }
        Direction[] directions = this.getDirectionSelector(module, tile).directions();
        block0: for (FluidFilter subFilter : fluidPipe.getFluidFilters()) {
            for (int slot = 0; slot < subFilter.getSlots(); ++slot) {
                Optional filtered;
                ItemStack filteredBucket = subFilter.getStackInSlot(slot);
                if (filteredBucket.isEmpty() || !(filtered = FluidUtil.getFluidContained((ItemStack)filteredBucket)).isPresent()) continue;
                FluidStack copy = ((FluidStack)filtered.get()).copy();
                copy.setAmount(this.maxExtraction);
                Pair<BlockPos, ItemStack> dest = fluidPipe.getAvailableDestination(directions, copy, true, this.preventOversending);
                if (dest == null) continue;
                ItemStack fluidItem = ((ItemStack)dest.getRight()).copy();
                if (PipeNetworkUtil.requestFluid(fluidPipe.getLevel(), fluidPipe.getBlockPos(), (BlockPos)dest.getLeft(), FluidItem.getFluidCopyFromItem(fluidItem)).isEmpty()) continue block0;
            }
        }
    }

    private FluidStack requestFilteredFromNetwork(Level level, BlockPos pos, FluidFilter filter) {
        for (FluidNetworkLocation location : PipeNetworkUtil.getOrderedNetworkFluids(level, pos)) {
            FluidStack fluid = location.getFirstAvailableFluid(level);
            if (!filter.isPipeFluidAllowed(fluid)) continue;
            return fluid;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public boolean canNetworkSee(ItemStack module, PipeBlockEntity tile, Direction direction, IItemHandler storage) {
        return tile instanceof FluidPipeBlockEntity && !this.getDirectionSelector(module, tile).has(direction);
    }

    @Override
    public boolean canAcceptItem(ItemStack module, PipeBlockEntity tile, ItemStack stack, Direction direction, IItemHandler storage) {
        return tile instanceof FluidPipeBlockEntity && !this.getDirectionSelector(module, tile).has(direction);
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeBlockEntity tile, IModule other) {
        return tile instanceof FluidPipeBlockEntity && !(other instanceof FluidRetrievalModuleItem);
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeBlockEntity tile) {
        return tile instanceof FluidPipeBlockEntity;
    }

    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeBlockEntity tile, int windowId, Inventory inv, Player player, int moduleIndex) {
        return new FluidRetrievalContainer((MenuType)MenuSetup.FLUID_RETRIEVAL.get(), windowId, player, tile.getBlockPos(), moduleIndex);
    }

    public DirectionSelector getDirectionSelector(ItemStack module, PipeBlockEntity tile) {
        return new FluidDirectionSelector(module, tile);
    }

    @Override
    public FluidFilter getFluidFilter(ItemStack module, FluidPipeBlockEntity tile) {
        FluidFilter filter = new FluidFilter(this.filterSlots, module, tile, true);
        return filter;
    }
}

