/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipe;

import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.item.FluidItem;
import dev.quarris.ppfluids.item.IFluidFilterProvider;
import dev.quarris.ppfluids.item.IFluidModule;
import dev.quarris.ppfluids.misc.FluidFilter;
import dev.quarris.ppfluids.pipenetwork.FluidPipeItem;
import dev.quarris.ppfluids.registry.BlockEntitySetup;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class FluidPipeBlockEntity
extends PipeBlockEntity {
    public FluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitySetup.FLUID_PIPE.get(), pos, state);
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(Direction[] directions, FluidStack fluid, boolean force, boolean preventOversending) {
        if (!this.canWork()) {
            return null;
        }
        for (Direction dir : directions) {
            PipeNetwork network;
            int onTheWay;
            int amountFilled;
            IFluidHandler tank = this.getFluidHandler(dir);
            if (tank == null || !force && this.streamModules().filter(m -> m.getRight() instanceof IFluidModule).anyMatch(m -> !((IFluidModule)m.getRight()).canAcceptItem((ItemStack)m.getLeft(), (PipeBlockEntity)this, FluidItem.createItemFromFluid(fluid), dir, tank)) || (amountFilled = tank.fill(fluid, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            FluidStack toInsert = fluid.copy();
            toInsert.setAmount(amountFilled);
            int maxAmount = this.streamModules().filter(m -> m.getRight() instanceof IFluidModule).mapToInt(m -> ((IFluidModule)m.getRight()).getMaxInsertionAmount((ItemStack)m.getLeft(), (PipeBlockEntity)this, fluid, tank)).min().orElse(Integer.MAX_VALUE);
            if (maxAmount < toInsert.getAmount()) {
                toInsert.setAmount(maxAmount);
            }
            BlockPos tankPos = this.getBlockPos().relative(dir);
            if ((preventOversending || maxAmount < Integer.MAX_VALUE) && (onTheWay = (network = PipeNetwork.get((Level)this.level)).getPipeItemsOnTheWay(tankPos).filter(item -> item instanceof FluidPipeItem).map(item -> (FluidPipeItem)((Object)item)).filter(item -> toInsert.getFluid().isSame(item.getFluidContent().getFluid())).mapToInt(item -> item.getFluidContent().getAmount()).sum()) > 0) {
                FluidStack copy = toInsert.copy();
                copy.setAmount(Integer.MAX_VALUE);
                int availableSpace = Math.min(maxAmount, tank.fill(copy, IFluidHandler.FluidAction.SIMULATE));
                if (onTheWay + toInsert.getAmount() > availableSpace) {
                    toInsert.setAmount(availableSpace - onTheWay);
                }
            }
            if (toInsert.isEmpty()) continue;
            return Pair.of((Object)tankPos, (Object)FluidItem.createItemFromFluid(toInsert));
        }
        return null;
    }

    public boolean canNetworkSee(Direction direction, IItemHandler handler) {
        return false;
    }

    public boolean canNetworkSee(Direction direction, IFluidHandler handler) {
        return this.streamModules().filter(m -> m.getRight() instanceof IFluidModule).allMatch(m -> ((IFluidModule)m.getRight()).canNetworkSee((ItemStack)m.getLeft(), (PipeBlockEntity)this, direction, handler));
    }

    public boolean canHaveModules() {
        for (Direction dir : Direction.values()) {
            if (this.getFluidHandler(dir) != null) {
                return true;
            }
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || !connectable.allowsModules(this.worldPosition, dir)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(Direction dir) {
        return super.isConnected(dir);
    }

    public IFluidHandler getFluidHandler(Direction dir) {
        IFluidHandler handler;
        if (!this.isConnected(dir)) {
            return null;
        }
        BlockPos pos = this.getBlockPos().relative(dir);
        BlockEntity tile = this.level.getBlockEntity(pos);
        if (tile != null && (handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)dir.getOpposite())) != null) {
            return handler;
        }
        return null;
    }

    public IItemHandler getItemHandler(Direction dir) {
        IFluidHandler fluidHandler = this.getFluidHandler(dir);
        if (fluidHandler != null) {
            // empty if block
        }
        return null;
    }

    public List<FluidFilter> getFluidFilters() {
        return this.streamModules().filter(p -> p.getRight() instanceof IFluidFilterProvider).map(p -> ((IFluidFilterProvider)p.getRight()).getFluidFilter((ItemStack)p.getLeft(), this)).collect(Collectors.toList());
    }
}

