/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.pipenetwork;

import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import dev.quarris.ppfluids.ModConfigs;
import dev.quarris.ppfluids.client.renderer.FluidBlobRenderer;
import dev.quarris.ppfluids.item.FluidItem;
import dev.quarris.ppfluids.pipe.FluidPipeBlockEntity;
import dev.quarris.ppfluids.pipenetwork.PipeNetworkUtil;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidPipeItem
extends PipeItem {
    public static final ResourceLocation FLUID_TYPE = ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"pipe_fluid");
    private long ticksExisted;

    public FluidPipeItem(ItemStack stack, float speed) {
        super(FLUID_TYPE, stack, speed);
    }

    public FluidPipeItem(HolderLookup.Provider provider, ResourceLocation type, CompoundTag nbt) {
        super(provider, type, nbt);
    }

    public FluidStack getFluidContent() {
        IFluidHandlerItem tank = FluidUtil.getFluidHandler((ItemStack)this.stack).orElse(null);
        if (tank != null) {
            return tank.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    public void updateInPipe(PipeBlockEntity currPipe) {
        super.updateInPipe(currPipe);
        ++this.ticksExisted;
    }

    public void drop(Level level, ItemStack stack) {
        if (((Boolean)ModConfigs.dropFluidContainers.get()).booleanValue()) {
            super.drop(level, stack);
        }
    }

    public long getTicksExisted() {
        return this.ticksExisted;
    }

    protected void onPathObstructed(PipeBlockEntity currPipe, boolean tryReturn) {
        if (currPipe.getLevel().isClientSide()) {
            return;
        }
        PipeNetwork network = PipeNetwork.get((Level)currPipe.getLevel());
        if (tryReturn) {
            if (!this.retryOnObstruction && network.routeItemToLocation(currPipe.getBlockPos(), this.destInventory, this.getStartPipe(), this.startInventory, this.stack, speed -> this)) {
                this.retryOnObstruction = true;
                return;
            }
            FluidStack remain = PipeNetworkUtil.routeFluid(currPipe.getLevel(), currPipe.getBlockPos(), this.destInventory, FluidItem.getFluidCopyFromItem(this.stack), (stack, speed) -> this, false);
            if (!remain.isEmpty()) {
                this.drop(currPipe.getLevel(), FluidItem.createItemFromFluid(remain));
            }
        } else {
            this.drop(currPipe.getLevel(), this.stack);
        }
    }

    protected ItemStack store(PipeBlockEntity currPipe) {
        if (currPipe instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity currFluidPipe = (FluidPipeBlockEntity)currPipe;
            Direction dir = Utility.getDirectionFromOffset((BlockPos)this.getDestInventory(), (BlockPos)this.getDestPipe());
            IPipeConnectable connectable = currFluidPipe.getPipeConnectable(dir);
            if (connectable != null) {
                return connectable.insertItem(currFluidPipe.getBlockPos(), dir, this.stack, false);
            }
            IFluidHandler handler = currFluidPipe.getFluidHandler(dir);
            if (handler == null) {
                return this.stack;
            }
            return FluidItem.insertFluid(handler, this.stack);
        }
        return super.store(currPipe);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.putLong("TicksExisted", this.ticksExisted);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.ticksExisted = nbt.getLong("TicksExisted");
    }

    public void render(PipeBlockEntity tile, PoseStack matrixStack, Random random, float partialTicks, int light, int overlay, MultiBufferSource buffer) {
        FluidBlobRenderer.render(this, matrixStack, random, partialTicks, light, overlay, buffer);
    }
}

