/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.ppfluids.registry;

import de.ellpeck.prettypipes.Registry;
import dev.quarris.ppfluids.network.FluidButtonPayload;
import dev.quarris.ppfluids.registry.BlockEntitySetup;
import dev.quarris.ppfluids.registry.DataComponentSetup;
import dev.quarris.ppfluids.registry.ItemSetup;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="ppfluids", bus=EventBusSubscriber.Bus.MOD)
public class RegistryEvents {
    @SubscribeEvent
    public static void registerPrettyPipesFluidsItemsToPrettyPipesCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().location().toString().equalsIgnoreCase("prettypipes:tab")) {
            ItemSetup.REGISTRY.getEntries().forEach(entry -> {
                Item item = (Item)entry.get();
                if (item == ItemSetup.FLUID_HOLDER.get()) {
                    return;
                }
                event.accept((ItemLike)item);
            });
        }
    }

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("ppfluids");
        registrar.playBidirectional(FluidButtonPayload.TYPE, FluidButtonPayload.CODEC, FluidButtonPayload::onMessage);
    }

    @SubscribeEvent
    public static void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidHandlerItemStack.Consumable(DataComponentSetup.FLUID_CONTENT, stack, Integer.MAX_VALUE), new ItemLike[]{(ItemLike)ItemSetup.FLUID_HOLDER.get()});
        event.registerBlockEntity(Registry.pipeConnectableCapability, (BlockEntityType)BlockEntitySetup.FLUID_PIPE.get(), (e, d) -> e);
    }
}

