/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_7225;
import net.minecraft.class_757;
import net.minecraft.class_8786;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.client.gui.handler.WoodcutterGuiHandler;
import net.satisfy.meadow.core.recipes.WoodcuttingRecipe;

public class WoodcutterGui
extends class_465<WoodcutterGuiHandler> {
    private static final class_2960 TEXTURE = Meadow.identifier("textures/gui/woodcutter.png");
    private final int recipeIconPosX = 58;
    private final int recipeIconPosY = 15;
    private final int maxRecipeIcons = 12;
    private final int recipeIconWidth = 16;
    private final int recipeIconHeight = 18;
    private final int recipeIconPerLine = 4;
    private boolean canCraft;
    private float scrollAmount;
    private boolean mouseClicked;
    private int scrollOffset;

    public WoodcutterGui(WoodcutterGuiHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        int posX = this.field_2776;
        int posY = this.field_2800;
        context.method_25302(TEXTURE, posX, posY, 0, 0, this.field_2792, this.field_2779);
        int k = (int)(41.0f * this.scrollAmount);
        if (this.shouldScroll()) {
            context.method_25302(TEXTURE, posX + 124, posY + 14 + k, 176, 0, 11, 15);
        }
        int recipeX = posX + 58;
        int recipeY = posY + 15;
        int scrollOffsetOFF = this.scrollOffset + 12;
        this.renderRecipeBackground(context, mouseX, mouseY, recipeX, recipeY, scrollOffsetOFF);
        this.renderRecipeIcons(context, recipeX, recipeY, scrollOffsetOFF);
    }

    private void renderRecipeBackground(class_332 context, int mouseX, int mouseY, int x, int y, int scrollOffsetOFF) {
        for (int i = this.scrollOffset; i < scrollOffsetOFF && i < ((WoodcutterGuiHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            int offsetedI = i - this.scrollOffset;
            int posX = x + 16 * (offsetedI % 4);
            int l = offsetedI / 4;
            int posY = y + 18 * l;
            int offsetY = this.field_2779;
            if (i == ((WoodcutterGuiHandler)this.field_2797).getSelectedRecipe()) {
                offsetY += 18;
            } else if (mouseX >= posX && mouseY >= posY && mouseX < posX + 16 && mouseY < posY + 18) {
                offsetY += 36;
            }
            context.method_25302(TEXTURE, posX, posY, 0, offsetY, 16, 18);
        }
    }

    private void renderRecipeIcons(class_332 context, int x, int y, int scrollOffsetOFF) {
        List<WoodcuttingRecipe> list = ((WoodcutterGuiHandler)this.field_2797).getAvailableRecipes().stream().map(class_8786::comp_1933).toList();
        for (int i = this.scrollOffset; i < scrollOffsetOFF && i < ((WoodcutterGuiHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            int offsetedI = i - this.scrollOffset;
            int k = x + 16 * (offsetedI % 4);
            int l = offsetedI / 4;
            int m = y + 18 * l + 1;
            assert (this.field_22787 != null);
            assert (this.field_22787.field_1687 != null);
            context.method_51427(list.get(i).method_8110((class_7225.class_7874)this.field_22787.field_1687.method_30349()), k, m);
        }
    }

    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);
        if (this.canCraft) {
            int i = this.field_2776 + 58;
            int j = this.field_2800 + 15;
            int scrollOffsetOFF = this.scrollOffset + 12;
            List<WoodcuttingRecipe> list = ((WoodcutterGuiHandler)this.field_2797).getAvailableRecipes().stream().map(class_8786::comp_1933).toList();
            for (int l = this.scrollOffset; l < scrollOffsetOFF && l < ((WoodcutterGuiHandler)this.field_2797).getAvailableRecipeCount(); ++l) {
                int offsetedL = l - this.scrollOffset;
                int n = i + offsetedL % 4 * 16;
                int o = j + offsetedL / 4 * 18;
                if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
                assert (this.field_22787 != null);
                assert (this.field_22787.field_1687 != null);
                context.method_51446(this.field_22793, list.get(l).method_8110((class_7225.class_7874)this.field_22787.field_1687.method_30349()), x, y);
            }
        }
    }

    private void onInventoryChange() {
        this.canCraft = ((WoodcutterGuiHandler)this.field_2797).canCraft();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.mouseClicked = false;
        if (this.canCraft) {
            int i = this.field_2776 + 58;
            int j = this.field_2800 + 15;
            int k = this.scrollOffset + 12;
            for (int l = this.scrollOffset; l < k; ++l) {
                int offsetedL = l - this.scrollOffset;
                double d = mouseX - (double)(i + offsetedL % 4 * 16);
                double e = mouseY - (double)(j + offsetedL / 4 * 18);
                if (!(d >= 0.0 && e >= 0.0 && d < 16.0 && e < 18.0 && ((WoodcutterGuiHandler)this.field_2797).method_7604((class_1657)Objects.requireNonNull(this.field_22787).field_1724, l))) continue;
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                assert (this.field_22787.field_1761 != null);
                this.field_22787.field_1761.method_2900(((WoodcutterGuiHandler)this.field_2797).field_7763, l);
                return true;
            }
            i = this.field_2776 + 124;
            j = this.field_2800 + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 11) && mouseY >= (double)j && mouseY < (double)(j + 58)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_2800 + 15;
            int j = i + 58;
            this.scrollAmount = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            float f = (float)amountY / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.scrollOffset = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean shouldScroll() {
        return this.canCraft && ((WoodcutterGuiHandler)this.field_2797).getAvailableRecipeCount() > 12;
    }

    protected int getMaxScroll() {
        return (((WoodcutterGuiHandler)this.field_2797).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    protected void method_25426() {
        super.method_25426();
    }
}

