/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3545;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.satisfy.meadow.core.block.StorageBlock;
import net.satisfy.meadow.core.block.entity.StorageBlockEntity;
import net.satisfy.meadow.core.registry.StorageTypeRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class FlowerBoxBlock
extends StorageBlock {
    private static final Supplier<class_265> voxelShapeSupplier = () -> {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.9375, (double)0.0, (double)0.5625, (double)1.0, (double)0.375, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.0, (double)0.5625, (double)0.0625, (double)0.375, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.5625, (double)0.9375, (double)0.375, (double)0.625), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.375, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.625, (double)0.9375, (double)0.3125, (double)0.9375), (class_247)class_247.field_1366);
        return shape;
    };
    public static final Map<class_2350, class_265> SHAPE = (Map)class_156.method_654(new HashMap(), map -> {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            map.put(direction, GeneralUtil.rotateShape(class_2350.field_11043, direction, voxelShapeSupplier.get()));
        }
    });

    public FlowerBoxBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE.get(state.method_11654((class_2769)field_11177));
    }

    @NotNull
    public class_1269 use(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof StorageBlockEntity) {
            StorageBlockEntity shelf = (StorageBlockEntity)be;
            Optional<class_3545<Float, Float>> opt = GeneralUtil.getRelativeHitCoordinatesForBlockFace(hit, class_2350.field_11036, this.unAllowedDirections());
            if (opt.isEmpty()) {
                return class_1269.field_5811;
            }
            class_3545<Float, Float> ff = opt.get();
            int i = this.getSection((Float)ff.method_15442(), (Float)ff.method_15441());
            if (i == Integer.MIN_VALUE) {
                return class_1269.field_5811;
            }
            if (!((class_1799)shelf.getInventory().get(i)).method_7960()) {
                this.remove(world, pos, player, shelf, i);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960() && this.canInsertStack(stack)) {
                this.add(world, pos, player, shelf, stack, i);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public class_2960 type() {
        return StorageTypeRegistry.FLOWER_BOX;
    }

    @Override
    public class_2350[] unAllowedDirections() {
        return new class_2350[]{class_2350.field_11033};
    }

    @Override
    public boolean canInsertStack(class_1799 stack) {
        return stack.method_31573(class_3489.field_15543);
    }

    @Override
    public int getSection(Float x, Float y) {
        return (double)x.floatValue() < 0.5 ? 0 : 1;
    }
}

