/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShutterBlock
extends class_2248
implements class_3737 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<GeneralUtil.ShutterType> TYPE = GeneralUtil.ShutterType.SHUTTER_TYPE;
    public static final class_2746 LEFT = class_2746.method_11825((String)"left");
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265[] SHAPES = new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0)};

    public ShutterBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)((Object)GeneralUtil.ShutterType.NONE))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        int shape = ((class_2350)state.method_11654((class_2769)FACING)).method_10161() + (((Boolean)state.method_11654((class_2769)OPEN)).booleanValue() ? (((Boolean)state.method_11654((class_2769)LEFT)).booleanValue() ? 3 : 1) : 0);
        return SHAPES[shape % 4];
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        boolean left;
        class_2350 facing = context.method_8042().method_10153();
        class_2680 blockState = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing);
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        class_243 clickLocation = context.method_17698();
        if (facing.method_10166() == class_2350.class_2351.field_11048) {
            left = clickLocation.field_1350 - (double)clickedPos.method_10260() > 0.5;
        } else {
            boolean bl = left = clickLocation.field_1352 - (double)clickedPos.method_10263() > 0.5;
        }
        if (context.method_7715() == class_2350.field_11043 || context.method_7715() == class_2350.field_11034) {
            left = !left;
        }
        blockState = (class_2680)blockState.method_11657((class_2769)LEFT, (Comparable)Boolean.valueOf(left));
        if (world.method_49803(clickedPos)) {
            blockState = (class_2680)((class_2680)blockState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true));
        }
        blockState = (class_2680)blockState.method_11657(TYPE, (Comparable)((Object)this.getType(blockState, world.method_8320(clickedPos.method_10084()), world.method_8320(clickedPos.method_10074()))));
        return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(clickedPos).method_15772() == class_3612.field_15910));
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        boolean powered = world.method_49803(pos);
        if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
            if ((Boolean)state.method_11654((class_2769)OPEN) != powered) {
                state = (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(powered));
                world.method_8396(null, pos, ShutterBlock.shutterSound(powered), class_3419.field_15245, 1.0f, 1.0f);
            }
            if (((Boolean)(state = (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered))).method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
            }
        }
        GeneralUtil.ShutterType type = this.getType(state, world.method_8320(pos.method_10084()), world.method_8320(pos.method_10074()));
        if (state.method_11654(TYPE) != type) {
            state = (class_2680)state.method_11657(TYPE, (Comparable)((Object)type));
        }
        world.method_8652(pos, state, 3);
    }

    @NotNull
    public class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1269 result = this.toggleShutters(state, level, pos, player);
        if (result.method_23665()) {
            return class_9062.method_55644((boolean)level.field_9236);
        }
        return class_9062.field_47731;
    }

    @NotNull
    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hit) {
        return this.toggleShutters(state, level, pos, player);
    }

    public class_1269 toggleShutters(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        state = (class_2680)state.method_28493((class_2769)OPEN);
        level.method_8652(pos, state, 3);
        if (player == null || !player.method_18276()) {
            this.toggleShutters(state, level, pos, (Boolean)state.method_11654((class_2769)OPEN));
        }
        level.method_8396(null, pos, ShutterBlock.shutterSound((Boolean)state.method_11654((class_2769)OPEN)), class_3419.field_15245, 1.0f, 1.0f);
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void toggleShutters(class_2680 state, class_1937 level, class_2338 pos, boolean open) {
        int i;
        class_2680 updateState = state;
        class_2338 updatePos = pos;
        if (state.method_11654(TYPE) == GeneralUtil.ShutterType.MIDDLE || state.method_11654(TYPE) == GeneralUtil.ShutterType.BOTTOM) {
            class_2680 above;
            int heightUp = level.method_8597().comp_652() - updatePos.method_10264();
            for (i = 0; i < heightUp && (above = level.method_8320(updatePos.method_10084())).method_27852(state.method_26204()) && above.method_11654((class_2769)FACING) == updateState.method_11654((class_2769)FACING) && above.method_11654((class_2769)LEFT) == updateState.method_11654((class_2769)LEFT) && (Boolean)above.method_11654((class_2769)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.method_10084();
                level.method_8652(updatePos, (class_2680)updateState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.method_11654(TYPE) == GeneralUtil.ShutterType.MIDDLE || state.method_11654(TYPE) == GeneralUtil.ShutterType.TOP) {
            class_2680 below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.method_8597().comp_651() - updatePos.method_10264();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.method_8320(updatePos.method_10074())).method_27852(state.method_26204()) && below.method_11654((class_2769)FACING) == updateState.method_11654((class_2769)FACING) && below.method_11654((class_2769)LEFT) == updateState.method_11654((class_2769)LEFT) && (Boolean)below.method_11654((class_2769)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.method_10074();
                level.method_8652(updatePos, (class_2680)updateState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public static class_3414 shutterSound(boolean open) {
        if (open) {
            return class_3417.field_40063;
        }
        return class_3417.field_40062;
    }

    public GeneralUtil.ShutterType getType(class_2680 state, class_2680 above, class_2680 below) {
        boolean shape_below_same;
        boolean shape_above_same = above.method_26204() == state.method_26204() && above.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING) && above.method_11654((class_2769)OPEN) == state.method_11654((class_2769)OPEN) && above.method_11654((class_2769)LEFT) == state.method_11654((class_2769)LEFT);
        boolean bl = shape_below_same = below.method_26204() == state.method_26204() && below.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING) && below.method_11654((class_2769)OPEN) == state.method_11654((class_2769)OPEN) && below.method_11654((class_2769)LEFT) == state.method_11654((class_2769)LEFT);
        if (shape_above_same && !shape_below_same) {
            return GeneralUtil.ShutterType.BOTTOM;
        }
        if (!shape_above_same && shape_below_same) {
            return GeneralUtil.ShutterType.TOP;
        }
        if (shape_above_same) {
            return GeneralUtil.ShutterType.MIDDLE;
        }
        return GeneralUtil.ShutterType.NONE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, TYPE, OPEN, LEFT, POWERED, WATERLOGGED});
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @NotNull
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    @NotNull
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }
}

