/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block.entity;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.satisfy.meadow.client.gui.handler.CheeseFormGuiHandler;
import net.satisfy.meadow.core.block.CheeseFormBlock;
import net.satisfy.meadow.core.recipes.CheeseFormRecipe;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import net.satisfy.meadow.core.registry.TagRegistry;
import net.satisfy.meadow.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheeseFormBlockEntity
extends class_2586
implements class_5558<CheeseFormBlockEntity>,
class_3908,
ImplementedInventory {
    private class_2371<class_1799> inventory;
    public static final int CAPACITY = 3;
    public static final int COOKING_TIME_IN_TICKS = 1800;
    private static final int OUTPUT_SLOT = 0;
    private int fermentationTime = 0;
    protected float experience;
    private static final int[] SLOTS_FOR_SIDE = new int[]{2};
    private static final int[] SLOTS_FOR_UP = new int[]{1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0};
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return CheeseFormBlockEntity.this.fermentationTime;
            }
            if (index == 1) {
                return 1800;
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                CheeseFormBlockEntity.this.fermentationTime = value;
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public CheeseFormBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)EntityTypeRegistry.CHEESE_FORM_BLOCK_ENTITY.get(), pos, state);
        this.inventory = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        if (side.equals((Object)class_2350.field_11036)) {
            return SLOTS_FOR_UP;
        }
        if (side.equals((Object)class_2350.field_11033)) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_SIDE;
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag, this.inventory, (class_7225.class_7874)provider);
        this.fermentationTime = compoundTag.method_10568("fermentationTime");
        this.experience = compoundTag.method_10583("experience");
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        class_1262.method_5426((class_2487)compoundTag, this.inventory, (class_7225.class_7874)provider);
        compoundTag.method_10575("fermentationTime", (short)this.fermentationTime);
        compoundTag.method_10548("experience", this.experience);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, CheeseFormBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        class_1863 recipeManager = world.method_8433();
        List recipes = recipeManager.method_30027((class_3956)RecipeRegistry.CHEESE.get());
        Optional<CheeseFormRecipe> recipe = Optional.ofNullable(this.getRecipe(recipes, this.inventory));
        if (recipe.isPresent()) {
            boolean done;
            class_5455 access = world.method_30349();
            boolean working = this.canCraft(recipe.get(), access);
            if (working) {
                ++this.fermentationTime;
                if (this.fermentationTime >= 1800) {
                    this.fermentationTime = 0;
                    this.craft(recipe.get(), access);
                    this.method_5431();
                }
            } else {
                this.fermentationTime = 0;
            }
            boolean bl = done = !((class_1799)this.inventory.getFirst()).method_7960();
            if ((Boolean)state.method_11654((class_2769)CheeseFormBlock.WORKING) != working || (Boolean)state.method_11654((class_2769)CheeseFormBlock.DONE) != done) {
                world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)CheeseFormBlock.WORKING, (Comparable)Boolean.valueOf(working))).method_11657((class_2769)CheeseFormBlock.DONE, (Comparable)Boolean.valueOf(done)));
            }
        }
    }

    private CheeseFormRecipe getRecipe(List<class_8786<CheeseFormRecipe>> recipes, class_2371<class_1799> inventory) {
        block0: for (class_8786<CheeseFormRecipe> recipeHolder : recipes) {
            CheeseFormRecipe recipe = (CheeseFormRecipe)recipeHolder.comp_1933();
            for (class_1856 ingredient : recipe.method_8117()) {
                boolean ingredientFound = false;
                for (int slotIndex = 1; slotIndex < inventory.size(); ++slotIndex) {
                    class_1799 slotItem = (class_1799)inventory.get(slotIndex);
                    if (!ingredient.method_8093(slotItem)) continue;
                    ingredientFound = true;
                    break;
                }
                if (ingredientFound) continue;
                continue block0;
            }
            return recipe;
        }
        return null;
    }

    private boolean canCraft(CheeseFormRecipe recipe, class_5455 manager) {
        if (recipe == null || recipe.method_8110((class_7225.class_7874)manager).method_7960()) {
            return false;
        }
        if (this.areInputsEmpty()) {
            return false;
        }
        class_1799 itemStack = this.method_5438(0);
        return itemStack.method_7960() || itemStack.method_31574(recipe.method_8110((class_7225.class_7874)manager).method_7909());
    }

    private boolean areInputsEmpty() {
        int emptyStacks = 0;
        for (int i = 1; i <= 2; ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            ++emptyStacks;
        }
        return emptyStacks == 2;
    }

    private void craft(CheeseFormRecipe recipe, class_5455 manager) {
        if (!this.canCraft(recipe, manager)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110((class_7225.class_7874)manager);
        class_1799 outputSlotStack = this.method_5438(0);
        if (outputSlotStack.method_7960()) {
            class_1799 output = recipeOutput.method_7972();
            this.method_5447(0, output);
        } else if (outputSlotStack.method_31574(recipeOutput.method_7909())) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        class_1799 slot1Stack = this.method_5438(1);
        if (recipe.method_8117().stream().anyMatch(entry -> entry.method_8093(slot1Stack))) {
            if (slot1Stack.method_31573(TagRegistry.MILK_BUCKET)) {
                this.method_5447(1, class_1802.field_8550.method_7854());
            } else if (slot1Stack.method_31573(TagRegistry.WOODEN_MILK_BUCKET)) {
                this.method_5447(1, ((class_1792)ObjectRegistry.WOODEN_BUCKET.get()).method_7854());
            } else {
                this.method_5434(1, 1);
            }
        }
        class_1799 slot2Stack = this.method_5438(2);
        if (recipe.method_8117().stream().anyMatch(entry -> entry.method_8093(slot2Stack))) {
            if (slot2Stack.method_31573(TagRegistry.MILK_BUCKET)) {
                this.method_5447(2, class_1802.field_8550.method_7854());
            } else if (slot2Stack.method_31573(TagRegistry.WOODEN_MILK_BUCKET)) {
                this.method_5447(2, ((class_1792)ObjectRegistry.WOODEN_BUCKET.get()).method_7854());
            } else if (slot2Stack.method_31573(TagRegistry.MILK)) {
                class_1799 bucket = slot2Stack.method_7909() == ObjectRegistry.WOODEN_MILK_BUCKET.get() ? ((class_1792)ObjectRegistry.WOODEN_BUCKET.get()).method_7854() : class_1802.field_8550.method_7854();
                this.method_5447(2, bucket);
            } else {
                this.method_5434(2, 1);
            }
        }
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        class_1799 stackInSlot = (class_1799)this.inventory.get(slot);
        boolean dirty = !stack.method_7960() && class_1799.method_7984((class_1799)stack, (class_1799)stackInSlot) && class_1799.method_7973((class_1799)stack, (class_1799)stackInSlot);
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        if (!(slot != 1 && slot != 2 || dirty)) {
            this.fermentationTime = 0;
            this.method_5431();
        }
    }

    @Override
    public boolean method_5443(class_1657 player) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return ((class_2248)ObjectRegistry.CHEESE_FORM.get()).method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new CheeseFormGuiHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }
}

