/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.entity;

import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1345;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5147;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_7988;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.core.entity.WoolyCowVariant;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoolyCowEntity
extends class_1429
implements class_5147,
class_7988<WoolyCowVariant> {
    private static final class_2940<Boolean> IS_SHEARED = class_2945.method_12791(WoolyCowEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(WoolyCowEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2960 COW_LOOT_TABLE = class_2960.method_60656((String)"entities");
    private int eatGrassTimer;
    private class_1345 eatGrassGoal;

    public WoolyCowEntity(class_1299<WoolyCowEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @NotNull
    protected class_5321<class_52> method_5991() {
        class_2960 location = class_2960.method_60656((String)"entities/cow");
        if (!this.isSheared()) {
            String s = this.getVariant().method_15434();
            location = Meadow.identifier("entities/" + s);
        }
        return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)location);
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8868)) {
            if (!this.method_37908().field_9236 && this.method_27072()) {
                this.method_6636(class_3419.field_15248);
                this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                itemStack.method_7970(1, (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        if (itemStack.method_31574((class_1792)ObjectRegistry.WOODEN_BUCKET.get()) && !this.method_6109()) {
            player.method_5783(class_3417.field_14691, 1.0f, 1.0f);
            class_1799 itemStack2 = class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)this.getVariant().getBucket().method_7854());
            player.method_6122(hand, itemStack2);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(@NotNull class_3419 shearedSoundCategory) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14975, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.field_5974.method_43048(3);
        for (int j = 0; j < i; ++j) {
            class_1542 itemEntity = this.method_5870((class_1935)this.getVariant().getWool(), 1);
            if (itemEntity == null) continue;
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Sheared", this.isSheared());
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setSheared(nbt.method_10577("Sheared"));
        this.setTypeVariant(nbt.method_10550("Variant"));
    }

    public boolean method_6481(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_49933);
    }

    public void method_5983() {
        super.method_5983();
        this.setSheared(false);
        if (this.method_6109()) {
            this.method_5615(60);
        }
    }

    protected void method_5958() {
        this.eatGrassTimer = this.eatGrassGoal.method_6258();
        super.method_5958();
    }

    public void method_6007() {
        if (this.method_37908().field_9236) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        super.method_6007();
    }

    public void setSheared(boolean sheared) {
        this.field_6011.method_12778(IS_SHEARED, (Object)sheared);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_SHEARED, (Object)false);
        builder.method_56912(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(IS_SHEARED);
    }

    public boolean method_27072() {
        return this.method_5805() && !this.isSheared() && !this.method_6109();
    }

    public void method_5711(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        } else {
            super.method_5711(status);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.eatGrassTimer >= 4 && this.eatGrassTimer <= 36) {
            return 1.0f;
        }
        if (this.eatGrassTimer < 4) {
            return ((float)this.eatGrassTimer - delta) / 4.0f;
        }
        return -((float)(this.eatGrassTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatGrassTimer > 4 && this.eatGrassTimer <= 36) {
            float f = ((float)(this.eatGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(f * 28.7f));
        }
        if (this.eatGrassTimer > 0) {
            return 0.62831855f;
        }
        return this.method_36455() * ((float)Math.PI / 180);
    }

    @Nullable
    public WoolyCowEntity getBreedOffspring(@NotNull class_3218 serverLevel, @NotNull class_1296 ageableMob) {
        WoolyCowEntity cow = (WoolyCowEntity)((class_1299)EntityTypeRegistry.WOOLY_COW.get()).method_5883((class_1937)serverLevel);
        if (cow == null) {
            return null;
        }
        class_5819 random = serverLevel.method_8409();
        WoolyCowVariant var = this.getVariant();
        if (random.method_43056() && ageableMob instanceof WoolyCowEntity) {
            WoolyCowEntity varCow = (WoolyCowEntity)ageableMob;
            var = varCow.getVariant();
        }
        cow.setVariant(var);
        return cow;
    }

    public class_1315 method_5943(class_5425 level, class_1266 diff, class_3730 reason, @Nullable class_1315 data) {
        WoolyCowVariant variant;
        if (reason == class_3730.field_16465) {
            int v = this.getTypeVariant() & 0xFF;
            this.setVariant(WoolyCowVariant.byId(v));
            return super.method_5943(level, diff, reason, data);
        }
        if (data instanceof ShearableVarCowGroupData) {
            ShearableVarCowGroupData d = (ShearableVarCowGroupData)((Object)data);
            variant = d.variant;
        } else {
            variant = WoolyCowVariant.getRandomVariant((class_1936)level, this.method_24515(), false);
            data = new ShearableVarCowGroupData(variant);
        }
        this.setVariant(variant);
        return super.method_5943(level, diff, reason, data);
    }

    public void setVariant(WoolyCowVariant variant) {
        this.setTypeVariant(variant.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    @NotNull
    public WoolyCowVariant getVariant() {
        return WoolyCowVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setTypeVariant(int i) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)i);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 2.0));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, (Predicate)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8861}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.25));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.eatGrassGoal = new class_1345((class_1308)this);
        this.field_6201.method_6277(5, (class_1352)this.eatGrassGoal);
    }

    protected class_3414 method_5994() {
        return class_3417.field_14780;
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return class_3417.field_14597;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14857;
    }

    protected void method_5712(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        this.method_5783(class_3417.field_15110, 0.15f, 1.0f);
    }

    protected float method_6107() {
        return 0.4f;
    }

    public double method_23320() {
        return super.method_23320();
    }

    public static class ShearableVarCowGroupData
    extends class_1296.class_4697 {
        public final WoolyCowVariant variant;

        public ShearableVarCowGroupData(WoolyCowVariant variant) {
            super(true);
            this.variant = variant;
        }
    }
}

