/*
 * Decompiled with CFR 0.152.
 */
package eu.pankraz01;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pankraz01.WastedConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3468;
import net.minecraft.class_3518;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

final class WastedCommand {
    private static final DateTimeFormatter LAST_SEEN_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.systemDefault());
    private static WastedConfig cachedConfig;

    private WastedCommand() {
    }

    static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wasted").requires(source -> source.method_9259(0))).executes(WastedCommand::executeSelf)).then(class_2170.method_9247((String)"list").executes(WastedCommand::executeList))).then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.word()).executes(ctx -> WastedCommand.executeTarget((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"target")))));
    }

    private static int executeSelf(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        WastedConfig config = WastedCommand.getConfig(source.method_9211());
        if (source.method_44023() != null) {
            class_3222 player = source.method_44023();
            return WastedCommand.sendPlaytimeMessage(source, player.method_7334().getName(), true, WastedCommand.getOnlinePlaytime(player), System.currentTimeMillis(), true, config.strings());
        }
        source.method_9213((class_2561)class_2561.method_43470((String)config.strings().consoleNeedsName));
        return 0;
    }

    private static int executeTarget(CommandContext<class_2168> context, String targetName) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        WastedConfig config = WastedCommand.getConfig(server);
        class_3222 online = server.method_3760().method_14566(targetName);
        if (online != null) {
            return WastedCommand.sendPlaytimeMessage(source, online.method_7334().getName(), false, WastedCommand.getOnlinePlaytime(online), System.currentTimeMillis(), true, config.strings());
        }
        Optional<GameProfile> profile = WastedCommand.resolveProfile(server, targetName);
        if (profile.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)config.strings().playerNotFound.replace("{player}", targetName)));
            return 0;
        }
        Optional<Long> playtime = WastedCommand.loadOfflinePlaytime(server, profile.get().getId());
        OptionalLong lastSeen = WastedCommand.loadOfflineLastPlayed(server, profile.get().getId());
        if (playtime.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)config.strings().noStatsFor.replace("{player}", targetName)));
            return 0;
        }
        return WastedCommand.sendPlaytimeMessage(source, profile.get().getName(), false, playtime.get(), lastSeen.isPresent() ? Long.valueOf(lastSeen.getAsLong()) : null, false, config.strings());
    }

    private static int executeList(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        WastedConfig config = WastedCommand.getConfig(server);
        Map<String, PlayerEntry> entries = WastedCommand.collectAllEntries(server);
        if (entries.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)config.strings().noStatsAny));
            return 0;
        }
        ArrayList<PlayerEntry> sorted = new ArrayList<PlayerEntry>(entries.values());
        sorted.sort(Comparator.comparingLong(e -> e.playtimeTicks).reversed());
        class_5250 message = class_2561.method_43470((String)config.strings().listHeader).method_27692(class_124.field_1065);
        for (PlayerEntry entry : sorted) {
            HashMap<String, class_2561> tokens = new HashMap<String, class_2561>();
            tokens.put("player", (class_2561)class_2561.method_43470((String)entry.name).method_27692(class_124.field_1075));
            tokens.put("time", (class_2561)class_2561.method_43470((String)WastedCommand.formatPlaytime(entry.playtimeTicks)).method_27692(class_124.field_1065));
            tokens.put("last", (class_2561)class_2561.method_43470((String)WastedCommand.formatLastSeen(entry.lastSeenMillis, entry.online, config.strings())).method_27692(class_124.field_1054));
            class_5250 line = WastedCommand.renderTemplate(config.strings().listEntry, tokens, class_124.field_1080);
            message.method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)line);
        }
        source.method_9226(() -> message, false);
        return 1;
    }

    private static int sendPlaytimeMessage(class_2168 source, String targetName, boolean self, long ticksPlayed, Long lastSeenMillis, boolean online, WastedConfig.Strings strings) {
        String formatted = WastedCommand.formatPlaytime(ticksPlayed);
        String playerLabel = self ? strings.selfLabel : targetName;
        HashMap<String, class_2561> tokens = new HashMap<String, class_2561>();
        tokens.put("player", (class_2561)class_2561.method_43470((String)playerLabel).method_27692(class_124.field_1075));
        tokens.put("time", (class_2561)class_2561.method_43470((String)formatted).method_27692(class_124.field_1065));
        tokens.put("last", (class_2561)class_2561.method_43470((String)WastedCommand.formatLastSeen(lastSeenMillis, online, strings)).method_27692(class_124.field_1054));
        class_5250 message = WastedCommand.renderTemplate(strings.wastedMessage, tokens, class_124.field_1080);
        source.method_9226(() -> message, false);
        return 1;
    }

    private static long getOnlinePlaytime(class_3222 player) {
        return player.method_14248().method_15024(class_3468.field_15419, (Object)class_3468.field_15417);
    }

    private static Map<String, PlayerEntry> collectAllEntries(MinecraftServer server) {
        HashMap<String, PlayerEntry> totals = new HashMap<String, PlayerEntry>();
        for (class_3222 player : server.method_3760().method_14571()) {
            String name = player.method_7334().getName();
            totals.put(name, new PlayerEntry(name, WastedCommand.getOnlinePlaytime(player), System.currentTimeMillis(), true));
        }
        Path statsDir = server.method_27050(class_5218.field_24181);
        if (Files.isDirectory(statsDir, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(statsDir);){
                files.filter(path -> path.getFileName().toString().endsWith(".json")).forEach(path -> {
                    String fileName = path.getFileName().toString();
                    String uuidPart = fileName.substring(0, fileName.length() - ".json".length());
                    try {
                        UUID uuid = UUID.fromString(uuidPart);
                        Optional<Long> playtime = WastedCommand.loadOfflinePlaytime(server, uuid);
                        OptionalLong lastSeen = WastedCommand.loadOfflineLastPlayed(server, uuid);
                        if (playtime.isPresent()) {
                            String name = WastedCommand.resolveProfile(server, uuid).map(GameProfile::getName).orElse(uuid.toString());
                            PlayerEntry current = (PlayerEntry)totals.get(name);
                            if (current == null || !current.online) {
                                totals.put(name, new PlayerEntry(name, current != null ? Math.max(current.playtimeTicks, playtime.get()) : playtime.get(), lastSeen.isPresent() ? Long.valueOf(lastSeen.getAsLong()) : null, current != null && current.online));
                            } else {
                                current.playtimeTicks = Math.max(current.playtimeTicks, playtime.get());
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return totals;
    }

    private static Optional<GameProfile> resolveProfile(MinecraftServer server, String name) {
        class_3312 cache = server.method_3793();
        return cache != null ? cache.method_14515(name) : Optional.empty();
    }

    private static Optional<GameProfile> resolveProfile(MinecraftServer server, UUID id) {
        class_3312 cache = server.method_3793();
        return cache != null ? cache.method_14512(id) : Optional.empty();
    }

    private static WastedConfig getConfig(MinecraftServer server) {
        if (cachedConfig == null) {
            cachedConfig = WastedConfig.load(server);
        }
        return cachedConfig;
    }

    private static OptionalLong loadOfflineLastPlayed(MinecraftServer server, UUID playerId) {
        Path statsFile;
        Path dataFile = server.method_27050(class_5218.field_24182).resolve(playerId.toString() + ".dat");
        if (Files.exists(dataFile, new LinkOption[0])) {
            try {
                class_2487 tag = class_2507.method_30613((Path)dataFile, (class_2505)class_2505.method_53898());
                if (tag != null && tag.method_10545("LastPlayed")) {
                    return OptionalLong.of(tag.method_10537("LastPlayed"));
                }
            }
            catch (IOException tag) {
                // empty catch block
            }
        }
        if (Files.exists(statsFile = server.method_27050(class_5218.field_24181).resolve(playerId.toString() + ".json"), new LinkOption[0])) {
            try {
                return OptionalLong.of(Files.getLastModifiedTime(statsFile, new LinkOption[0]).toMillis());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return OptionalLong.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Long> loadOfflinePlaytime(MinecraftServer server, UUID playerId) {
        Path statsDir = server.method_27050(class_5218.field_24181);
        Path statsFile = statsDir.resolve(playerId.toString() + ".json");
        if (!Files.exists(statsFile, new LinkOption[0])) {
            return Optional.empty();
        }
        try (BufferedReader reader = Files.newBufferedReader(statsFile, StandardCharsets.UTF_8);){
            String key;
            JsonElement parsed = JsonParser.parseReader((Reader)reader);
            if (!parsed.isJsonObject()) {
                Optional<Long> optional = Optional.empty();
                return optional;
            }
            JsonObject root = parsed.getAsJsonObject();
            if (!root.has("stats")) {
                Optional<Long> optional = Optional.empty();
                return optional;
            }
            JsonObject statsObject = class_3518.method_15296((JsonObject)root, (String)"stats");
            if (!statsObject.has("minecraft:custom")) {
                Optional<Long> optional = Optional.empty();
                return optional;
            }
            JsonObject custom = class_3518.method_15296((JsonObject)statsObject, (String)"minecraft:custom");
            if (!custom.has(key = class_3468.field_15417.toString())) {
                Optional<Long> optional = Optional.empty();
                return optional;
            }
            Optional<Long> optional = Optional.of(custom.get(key).getAsLong());
            return optional;
        }
        catch (IOException | IllegalStateException ex) {
            return Optional.empty();
        }
    }

    private static String formatLastSeen(Long lastSeenMillis, boolean online, WastedConfig.Strings strings) {
        if (online) {
            return strings.lastOnlineNow;
        }
        if (lastSeenMillis == null) {
            return strings.lastOnlineUnknown;
        }
        return LAST_SEEN_FORMAT.format(Instant.ofEpochMilli(lastSeenMillis));
    }

    private static String formatPlaytime(long ticks) {
        long seconds = ticks / 20L;
        long days = seconds / 86400L;
        long hours = (seconds -= days * 86400L) / 3600L;
        long minutes = (seconds -= hours * 3600L) / 60L;
        seconds -= minutes * 60L;
        StringBuilder builder = new StringBuilder();
        if (days > 0L) {
            builder.append(days).append("d ");
        }
        if (hours > 0L || days > 0L) {
            builder.append(hours).append("h ");
        }
        if (minutes > 0L || hours > 0L || days > 0L) {
            builder.append(minutes).append("m ");
        }
        builder.append(seconds).append("s");
        return builder.toString().trim();
    }

    private static class_5250 renderTemplate(String template, Map<String, class_2561> tokens, class_124 baseColor) {
        class_5250 out = class_2561.method_43470((String)"");
        int index = 0;
        while (index < template.length()) {
            String key;
            class_2561 token;
            int start = template.indexOf(123, index);
            if (start < 0) {
                out.method_10852((class_2561)class_2561.method_43470((String)template.substring(index)).method_27692(baseColor));
                break;
            }
            int end = template.indexOf(125, start);
            if (end < 0) {
                out.method_10852((class_2561)class_2561.method_43470((String)template.substring(index)).method_27692(baseColor));
                break;
            }
            if (start > index) {
                out.method_10852((class_2561)class_2561.method_43470((String)template.substring(index, start)).method_27692(baseColor));
            }
            if ((token = tokens.get(key = template.substring(start + 1, end))) != null) {
                out.method_10852(token);
            } else {
                out.method_10852((class_2561)class_2561.method_43470((String)template.substring(start, end + 1)).method_27692(baseColor));
            }
            index = end + 1;
        }
        return out;
    }

    private static final class PlayerEntry {
        final String name;
        long playtimeTicks;
        final Long lastSeenMillis;
        final boolean online;

        PlayerEntry(String name, long playtimeTicks, Long lastSeenMillis, boolean online) {
            this.name = name;
            this.playtimeTicks = playtimeTicks;
            this.lastSeenMillis = lastSeenMillis;
            this.online = online;
        }
    }
}

