/*
 * Decompiled with CFR 0.152.
 */
package eu.pankraz01;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.MinecraftServer;

final class WastedConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "wasted_on_server.json";
    private final Strings strings;

    private WastedConfig(Strings strings) {
        this.strings = strings;
    }

    Strings strings() {
        return this.strings;
    }

    static void ensureGenerated(MinecraftServer server) {
        WastedConfig.load(server);
    }

    static WastedConfig load(MinecraftServer server) {
        Path configDir = server.method_3758("config");
        Path file = configDir.resolve(FILE_NAME);
        if (Files.notExists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Strings loaded = null;
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader reader2 = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                loaded = (Strings)GSON.fromJson((Reader)reader2, Strings.class);
            }
            catch (IOException reader2) {
                // empty catch block
            }
        }
        if (loaded == null) {
            loaded = new Strings();
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((Object)loaded, (Appendable)writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new WastedConfig(loaded.fillDefaults());
    }

    static final class Strings {
        public String selfLabel = "You";
        public String wastedMessage = "{player} wasted {time} Time on this Server (last: {last})";
        public String consoleNeedsName = "Bitte einen Spielernamen angeben, wenn die Konsole den Befehl ausfuehrt.";
        public String playerNotFound = "Spieler nicht gefunden: {player}";
        public String noStatsFor = "Keine gespeicherten Statistiken fuer {player} gefunden.";
        public String noStatsAny = "Keine gespeicherten Spielzeiten gefunden.";
        public String listHeader = "Spielzeiten (absteigend):";
        public String listEntry = "{player} -> {time} | last: {last}";
        public String lastOnlineNow = "online jetzt";
        public String lastOnlineUnknown = "unbekannt";

        Strings() {
        }

        Strings fillDefaults() {
            if (this.selfLabel == null || this.selfLabel.isEmpty()) {
                this.selfLabel = "You";
            }
            if (this.wastedMessage == null || this.wastedMessage.isEmpty()) {
                this.wastedMessage = "{player} wasted {time} Time on this Server (last: {last})";
            }
            if (this.consoleNeedsName == null || this.consoleNeedsName.isEmpty()) {
                this.consoleNeedsName = "Bitte einen Spielernamen angeben, wenn die Konsole den Befehl ausfuehrt.";
            }
            if (this.playerNotFound == null || this.playerNotFound.isEmpty()) {
                this.playerNotFound = "Spieler nicht gefunden: {player}";
            }
            if (this.noStatsFor == null || this.noStatsFor.isEmpty()) {
                this.noStatsFor = "Keine gespeicherten Statistiken fuer {player} gefunden.";
            }
            if (this.noStatsAny == null || this.noStatsAny.isEmpty()) {
                this.noStatsAny = "Keine gespeicherten Spielzeiten gefunden.";
            }
            if (this.listHeader == null || this.listHeader.isEmpty()) {
                this.listHeader = "Spielzeiten (absteigend):";
            }
            if (this.listEntry == null || this.listEntry.isEmpty()) {
                this.listEntry = "{player} -> {time} | last: {last}";
            }
            if (this.lastOnlineNow == null || this.lastOnlineNow.isEmpty()) {
                this.lastOnlineNow = "online jetzt";
            }
            if (this.lastOnlineUnknown == null || this.lastOnlineUnknown.isEmpty()) {
                this.lastOnlineUnknown = "unbekannt";
            }
            return this;
        }
    }
}

