/*
 * Decompiled with CFR 0.152.
 */
package com.crafter.block.entity;

import com.crafter.BetterCrafter;
import com.crafter.screen.SmartCrafterScreenHandler;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class SmartCrafterBlockEntity
extends class_2586
implements class_1278,
ExtendedScreenHandlerFactory<BetterCrafter.SmartCrafterPayload> {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)10, (Object)class_1799.field_8037);
    private final class_2371<class_1799> ghostSlots = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private boolean locked = false;
    private boolean smartMode = false;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return SmartCrafterBlockEntity.this.locked ? 1 : 0;
                }
                case 1: {
                    return SmartCrafterBlockEntity.this.smartMode ? 1 : 0;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    SmartCrafterBlockEntity.this.setLocked(value > 0);
                    break;
                }
                case 1: {
                    SmartCrafterBlockEntity.this.setSmartMode(value > 0);
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public SmartCrafterBlockEntity(class_2338 pos, class_2680 state) {
        super(BetterCrafter.SMART_CRAFTER_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, SmartCrafterBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (blockEntity.smartMode) {
            blockEntity.attemptSmartCraft(world);
        }
    }

    private void attemptSmartCraft(class_1937 world) {
        if (!this.inputsReady()) {
            return;
        }
        ArrayList<class_1799> inputs = new ArrayList<class_1799>();
        for (int i = 0; i < 9; ++i) {
            inputs.add((class_1799)this.inventory.get(i));
        }
        class_9694 input = class_9694.method_59986((int)3, (int)3, inputs);
        Optional match = world.method_8433().method_8132(class_3956.field_17545, (class_9695)input, world);
        if (match.isPresent()) {
            class_3955 recipe = (class_3955)((class_8786)match.get()).comp_1933();
            class_1799 result = recipe.method_8116((class_9695)input, (class_7225.class_7874)world.method_30349());
            class_1799 outputStack = (class_1799)this.inventory.get(9);
            if (!(outputStack.method_7960() || class_1799.method_7984((class_1799)outputStack, (class_1799)result) && outputStack.method_7947() + result.method_7947() <= outputStack.method_7914())) {
                return;
            }
            class_2371 remainders = recipe.method_8111((class_9695)input);
            if (outputStack.method_7960()) {
                this.inventory.set(9, (Object)result.method_7972());
            } else {
                outputStack.method_7933(result.method_7947());
            }
            for (int i = 0; i < 9; ++i) {
                class_1799 remainder;
                class_1799 itemStack = (class_1799)this.inventory.get(i);
                class_1799 class_17992 = remainder = i < remainders.size() ? (class_1799)remainders.get(i) : class_1799.field_8037;
                if (!itemStack.method_7960()) {
                    ((class_1799)this.inventory.get(i)).method_7934(1);
                    itemStack = (class_1799)this.inventory.get(i);
                }
                if (remainder.method_7960()) continue;
                if (itemStack.method_7960()) {
                    this.inventory.set(i, (Object)remainder);
                    continue;
                }
                if (!class_1799.method_7984((class_1799)itemStack, (class_1799)remainder) || itemStack.method_7947() >= itemStack.method_7914()) continue;
                itemStack.method_7933(remainder.method_7947());
            }
            this.method_5431();
        }
    }

    private boolean inputsReady() {
        if (this.locked) {
            for (int i = 0; i < 9; ++i) {
                class_1799 ghost = (class_1799)this.ghostSlots.get(i);
                if (ghost.method_7960() || !((class_1799)this.inventory.get(i)).method_7960()) continue;
                return false;
            }
            return true;
        }
        return !this.method_5442();
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2371<class_1799> getGhostItems() {
        return this.ghostSlots;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        if (locked) {
            for (int i = 0; i < 9; ++i) {
                class_1799 stack = ((class_1799)this.inventory.get(i)).method_7972();
                if (!stack.method_7960()) {
                    stack.method_7939(1);
                }
                this.ghostSlots.set(i, (Object)stack);
            }
        }
        this.method_5431();
    }

    public boolean isSmartMode() {
        return this.smartMode;
    }

    public void setSmartMode(boolean smartMode) {
        this.smartMode = smartMode;
        this.method_5431();
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        class_2487 ghostNbt = new class_2487();
        class_1262.method_5426((class_2487)ghostNbt, this.ghostSlots, (class_7225.class_7874)registryLookup);
        nbt.method_10566("GhostSlots", (class_2520)ghostNbt);
        nbt.method_10556("Locked", this.locked);
        nbt.method_10556("SmartMode", this.smartMode);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        if (nbt.method_10545("GhostSlots")) {
            class_2487 ghostNbt = nbt.method_10562("GhostSlots");
            class_1262.method_5429((class_2487)ghostNbt, this.ghostSlots, (class_7225.class_7874)registryLookup);
        }
        this.locked = nbt.method_10577("Locked");
        this.smartMode = nbt.method_10577("SmartMode");
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"container.better_crafter.smart_crafter");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        class_1263 ghostInv = new class_1263(){

            public int method_5439() {
                return 9;
            }

            public boolean method_5442() {
                return SmartCrafterBlockEntity.this.ghostSlots.isEmpty();
            }

            public class_1799 method_5438(int slot) {
                return (class_1799)SmartCrafterBlockEntity.this.ghostSlots.get(slot);
            }

            public class_1799 method_5434(int slot, int amount) {
                return class_1262.method_5430(SmartCrafterBlockEntity.this.ghostSlots, (int)slot, (int)amount);
            }

            public class_1799 method_5441(int slot) {
                return class_1262.method_5428(SmartCrafterBlockEntity.this.ghostSlots, (int)slot);
            }

            public void method_5447(int slot, class_1799 stack) {
                SmartCrafterBlockEntity.this.ghostSlots.set(slot, (Object)stack);
                this.method_5431();
            }

            public void method_5431() {
                SmartCrafterBlockEntity.this.method_5431();
            }

            public boolean method_5443(class_1657 player) {
                return true;
            }

            public void method_5448() {
                SmartCrafterBlockEntity.this.ghostSlots.clear();
            }
        };
        return new SmartCrafterScreenHandler(syncId, playerInventory, (class_1263)this, ghostInv, this.propertyDelegate, this.field_11867);
    }

    public BetterCrafter.SmartCrafterPayload getScreenOpeningData(class_3222 player) {
        return new BetterCrafter.SmartCrafterPayload(this.field_11867);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.method_5431();
        }
        return result;
    }

    public class_1799 method_5441(int slot) {
        class_1799 result = class_1262.method_5428(this.inventory, (int)slot);
        this.method_5431();
        return result;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot >= 9) {
            return true;
        }
        if (this.locked) {
            class_1799 ghostStack = (class_1799)this.ghostSlots.get(slot);
            if (ghostStack.method_7960()) {
                return false;
            }
            return class_1799.method_7984((class_1799)stack, (class_1799)ghostStack);
        }
        return true;
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{9};
        }
        if (this.locked && side != class_2350.field_11033) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i2 = 0; i2 < 9; ++i2) {
                if (((class_1799)this.ghostSlots.get(i2)).method_7960() || !((class_1799)this.inventory.get(i2)).method_7960()) continue;
                slots.add(i2);
            }
            return slots.stream().mapToInt(i -> i).toArray();
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        class_1799 current;
        if (slot >= 9) {
            return false;
        }
        if (!this.method_5437(slot, stack)) {
            return false;
        }
        return !this.locked || (current = this.method_5438(slot)).method_7960();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 9;
    }
}

