/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.mixin;

import de.erdbeerbaerlp.dcintegration.architectury.util.MessageUtilsImpl;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerAdvancements.class})
public class AdvancementMixin {
    @Shadow
    private ServerPlayer player;

    @Inject(method={"award(Lnet/minecraft/advancements/AdvancementHolder;Ljava/lang/String;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerAdvancements;markForVisibilityUpdate(Lnet/minecraft/advancements/AdvancementHolder;)V")})
    public void advancement(AdvancementHolder advancementEntry, String criterionName, CallbackInfoReturnable<Boolean> cir) {
        if (DiscordIntegration.INSTANCE == null) {
            return;
        }
        if (DiscordIntegration.INSTANCE.getServerInterface().isPlayerVanish(this.player.getUUID())) {
            return;
        }
        Advancement advancement = advancementEntry.value();
        if (LinkManager.isPlayerLinked(this.player.getUUID()) && LinkManager.getLink(null, (UUID)this.player.getUUID()).settings.hideFromDiscord) {
            return;
        }
        if (advancement.display().isPresent() && ((DisplayInfo)advancement.display().get()).shouldAnnounceChat() && !Localization.instance().advancementMessage.isBlank()) {
            if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.advancementMessage.asEmbed) {
                String avatarURL = DiscordIntegration.INSTANCE.getSkinURL().replace("%uuid%", this.player.getUUID().toString()).replace("%uuid_dashless%", this.player.getUUID().toString().replace("-", "")).replace("%name%", this.player.getName().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
                if (!Configuration.instance().embedMode.advancementMessage.customJSON.isBlank()) {
                    EmbedBuilder b = Configuration.instance().embedMode.advancementMessage.toEmbedJson(Configuration.instance().embedMode.advancementMessage.customJSON.replace("%uuid%", this.player.getUUID().toString()).replace("%uuid_dashless%", this.player.getUUID().toString().replace("-", "")).replace("%name%", MessageUtilsImpl.formatPlayerName(this.player)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%advName%", ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getTitle().getString())).replace("%advDesc%", ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getDescription().getString())).replace("%advNameURL%", URLEncoder.encode(ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getTitle().getString()), StandardCharsets.UTF_8)).replace("%advDescURL%", URLEncoder.encode(ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getDescription().getString()), StandardCharsets.UTF_8)).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID(this.player.getUUID()).getRGB()));
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                } else {
                    EmbedBuilder b = Configuration.instance().embedMode.advancementMessage.toEmbed();
                    b = b.setAuthor(MessageUtilsImpl.formatPlayerName(this.player), null, avatarURL).setDescription(Localization.instance().advancementMessage.replace("%player%", ChatFormatting.stripFormatting((String)MessageUtilsImpl.formatPlayerName(this.player))).replace("%advName%", ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getTitle().getString())).replace("%advDesc%", ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getDescription().getString())).replace("\\n", "\n").replace("%advNameURL%", URLEncoder.encode(ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getTitle().getString()), StandardCharsets.UTF_8)).replace("%advDescURL%", URLEncoder.encode(ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getDescription().getString()), StandardCharsets.UTF_8)));
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            } else {
                DiscordIntegration.INSTANCE.sendMessage(Localization.instance().advancementMessage.replace("%player%", ChatFormatting.stripFormatting((String)MessageUtilsImpl.formatPlayerName(this.player))).replace("%advName%", ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getTitle().getString())).replace("%advDesc%", ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getDescription().getString())).replace("%advNameURL%", URLEncoder.encode(ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getTitle().getString()), StandardCharsets.UTF_8)).replace("%advDescURL%", URLEncoder.encode(ChatFormatting.stripFormatting((String)((DisplayInfo)advancement.display().get()).getDescription().getString()), StandardCharsets.UTF_8)).replace("\\n", "\n"), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
            }
        }
    }
}

