/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.mixin;

import de.erdbeerbaerlp.dcintegration.architectury.DiscordIntegrationMod;
import de.erdbeerbaerlp.dcintegration.architectury.util.MessageUtilsImpl;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.Localization;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.LinkManager;
import de.erdbeerbaerlp.dcintegration.common.util.DiscordMessage;
import de.erdbeerbaerlp.dcintegration.common.util.TextColors;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class NetworkHandlerMixin {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"onDisconnect(Lnet/minecraft/network/DisconnectionDetails;)V"}, at={@At(value="HEAD")})
    private void onDisconnect(DisconnectionDetails disconnectionDetails, CallbackInfo ci) {
        Component reason = disconnectionDetails.reason();
        if (DiscordIntegrationMod.stopped) {
            return;
        }
        if (DiscordIntegration.INSTANCE.getServerInterface().isPlayerVanish(this.player.getUUID())) {
            return;
        }
        if (LinkManager.isPlayerLinked(this.player.getUUID()) && LinkManager.getLink(null, (UUID)this.player.getUUID()).settings.hideFromDiscord) {
            return;
        }
        if (reason.equals((Object)Component.translatable((String)"disconnect.timeout"))) {
            DiscordIntegrationMod.timeouts.add(this.player.getUUID());
        }
        DiscordIntegration.INSTANCE.callEventC(a -> a.onPlayerLeave(this.player.getUUID()));
        String avatarURL = DiscordIntegration.INSTANCE.getSkinURL().replace("%uuid%", this.player.getUUID().toString()).replace("%uuid_dashless%", this.player.getUUID().toString().replace("-", "")).replace("%name%", this.player.getName().getString()).replace("%randomUUID%", UUID.randomUUID().toString());
        if (DiscordIntegration.INSTANCE != null && !DiscordIntegrationMod.timeouts.contains(this.player.getUUID())) {
            if (!Localization.instance().playerLeave.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerLeaveMessages.asEmbed) {
                    if (!Configuration.instance().embedMode.playerLeaveMessages.customJSON.isBlank()) {
                        EmbedBuilder b = Configuration.instance().embedMode.playerLeaveMessages.toEmbedJson(Configuration.instance().embedMode.playerLeaveMessages.customJSON.replace("%uuid%", this.player.getUUID().toString()).replace("%uuid_dashless%", this.player.getUUID().toString().replace("-", "")).replace("%name%", MessageUtilsImpl.formatPlayerName(this.player)).replace("%randomUUID%", UUID.randomUUID().toString()).replace("%avatarURL%", avatarURL).replace("%playerColor%", "" + TextColors.generateFromUUID(this.player.getUUID()).getRGB()));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    } else {
                        EmbedBuilder b = Configuration.instance().embedMode.playerLeaveMessages.toEmbed().setAuthor(MessageUtilsImpl.formatPlayerName(this.player), null, avatarURL).setDescription(Localization.instance().playerLeave.replace("%player%", MessageUtilsImpl.formatPlayerName(this.player)));
                        DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                    }
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerLeave.replace("%player%", MessageUtilsImpl.formatPlayerName(this.player)), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
        } else if (DiscordIntegration.INSTANCE != null && DiscordIntegrationMod.timeouts.contains(this.player.getUUID())) {
            if (!Localization.instance().playerTimeout.isBlank()) {
                if (Configuration.instance().embedMode.enabled && Configuration.instance().embedMode.playerLeaveMessages.asEmbed) {
                    EmbedBuilder b = Configuration.instance().embedMode.playerLeaveMessages.toEmbed().setAuthor(MessageUtilsImpl.formatPlayerName(this.player), null, avatarURL).setDescription(Localization.instance().playerTimeout.replace("%player%", MessageUtilsImpl.formatPlayerName(this.player)));
                    DiscordIntegration.INSTANCE.sendMessage(new DiscordMessage(b.build()), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                } else {
                    DiscordIntegration.INSTANCE.sendMessage(Localization.instance().playerTimeout.replace("%player%", MessageUtilsImpl.formatPlayerName(this.player)), (MessageChannel)DiscordIntegration.INSTANCE.getChannel(Configuration.instance().advanced.serverChannelID));
                }
            }
            DiscordIntegrationMod.timeouts.remove(this.player.getUUID());
        }
    }
}

