/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import de.erdbeerbaerlp.dcintegration.architectury.util.SerializeComponentUtils;
import de.erdbeerbaerlp.dcintegration.architectury.util.TooltipUtils;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.util.MessageUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class MessageUtilsImpl
extends MessageUtils {
    public static String formatPlayerName(ServerPlayer player) {
        if (player.getTabListDisplayName() != null) {
            return ChatFormatting.stripFormatting((String)player.getTabListDisplayName().getString());
        }
        return ChatFormatting.stripFormatting((String)player.getName().getString());
    }

    public static MessageEmbed genItemStackEmbedIfAvailable(Component component, Level w) {
        JsonObject json;
        if (!Configuration.instance().forgeSpecific.sendItemInfo) {
            return null;
        }
        try {
            JsonElement jsonElement = JsonParser.parseString((String)SerializeComponentUtils.toJson(component, w.registryAccess()));
            DiscordIntegration.LOGGER.info("JSON-Element: " + String.valueOf(jsonElement));
            if (!jsonElement.isJsonObject()) {
                return null;
            }
            json = jsonElement.getAsJsonObject();
        }
        catch (IllegalStateException ex) {
            DiscordIntegration.LOGGER.error("There was an error parsing JSON", (Throwable)ex);
            return null;
        }
        DiscordIntegration.LOGGER.info("JSON: " + String.valueOf(json));
        System.out.println(json);
        if (json.has("with")) {
            JsonArray args2 = json.getAsJsonArray("with");
            for (JsonElement el : args2) {
                JsonObject hoverEvent;
                JsonObject arg1;
                if (!(el instanceof JsonObject) || !(arg1 = (JsonObject)el).has("hoverEvent") || !(hoverEvent = arg1.getAsJsonObject("hoverEvent")).has("action") || !hoverEvent.get("action").getAsString().equals("show_item") || !hoverEvent.has("contents") || !hoverEvent.getAsJsonObject("contents").has("components")) continue;
                JsonObject item = hoverEvent.getAsJsonObject("contents").getAsJsonObject();
                try {
                    ItemLore l;
                    ItemEnchantments e;
                    CompoundTag tag = CompoundTagArgument.compoundTag().parse(new StringReader(item.toString()));
                    ItemStack is = (ItemStack)ItemStack.CODEC.parse((DynamicOps)w.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).getOrThrow(JsonParseException::new);
                    DataComponentMap itemTag = is.getComponents();
                    EmbedBuilder b = new EmbedBuilder();
                    Component title = (Component)itemTag.getOrDefault(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)is.getItem().getDescriptionId(), (Object[])new Object[]{is.getItem().getName(is).getString(), null}));
                    if (title.toString().isEmpty()) {
                        title = Component.translatable((String)is.getItem().getDescriptionId());
                    } else {
                        b.setFooter(is.getItemHolder().getRegisteredName());
                    }
                    b.setTitle(title.getString());
                    StringBuilder tooltip = new StringBuilder();
                    if (itemTag.has(DataComponents.ENCHANTMENTS) && (e = (ItemEnchantments)itemTag.get(DataComponents.ENCHANTMENTS)) != null && TooltipUtils.showsInTooltip(is)) {
                        for (Object2IntMap.Entry ench : e.entrySet()) {
                            Enchantment cfr_ignored_0 = (Enchantment)((Holder)ench.getKey()).value();
                            tooltip.append(ChatFormatting.stripFormatting((String)Enchantment.getFullname((Holder)((Holder)ench.getKey()), (int)e.getLevel((Holder)ench.getKey())).getString())).append("\n");
                        }
                    }
                    if (itemTag.has(DataComponents.LORE) && (l = (ItemLore)itemTag.get(DataComponents.LORE)) != null) {
                        for (Component line : l.lines()) {
                            tooltip.append("_").append(line.getString()).append("_\n");
                        }
                    }
                    if (!is.isDamageableItem()) {
                        tooltip.append("Unbreakable\n");
                    }
                    b.setDescription(tooltip.toString());
                    return b.build();
                }
                catch (CommandSyntaxException ignored) {
                    DiscordIntegration.LOGGER.error("Error", (Throwable)ignored);
                }
            }
        }
        return null;
    }
}

