/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.architectury.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;

public class SerializeComponentUtils {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static String toJson(Component component, RegistryAccess registryAccess) {
        JsonElement jsonElement = (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)component).getOrThrow(JsonParseException::new);
        return GSON.toJson(jsonElement);
    }

    public static String toJson(Component component, HolderLookup.Provider holderLookup) {
        JsonElement jsonElement = (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)holderLookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)component).getOrThrow(JsonParseException::new);
        return GSON.toJson(jsonElement);
    }

    public static MutableComponent fromJson(String json, RegistryAccess registryAccess) {
        JsonElement jsonElement = JsonParser.parseString((String)json);
        Component component = (Component)ComponentSerialization.CODEC.parse((DynamicOps)registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement).getOrThrow(JsonParseException::new);
        return component.copy();
    }

    public static MutableComponent fromJson(String json, HolderLookup.Provider holderLookup) {
        JsonElement jsonElement = JsonParser.parseString((String)json);
        Component component = (Component)ComponentSerialization.CODEC.parse((DynamicOps)holderLookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)jsonElement).getOrThrow(JsonParseException::new);
        return component.copy();
    }
}

