/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.storage;

import dcshadow.com.moandjiezana.toml.Toml;
import dcshadow.com.moandjiezana.toml.TomlComment;
import dcshadow.com.moandjiezana.toml.TomlIgnore;
import dcshadow.com.moandjiezana.toml.TomlWriter;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.configCmd.ConfigCommand;
import java.io.IOException;
import java.util.ArrayList;

public class Commands {
    @TomlIgnore
    private static Commands INSTANCE;
    @TomlIgnore
    private static final ConfigCommand[] defaultCommands;
    @TomlComment(value={"Add your custom commands here", "You can also generate some on https://erdbeerbaerlp.de/dcintegration-commands/", "If empty, there are no commands to generate"})
    public CommandsCont commands = new CommandsCont();
    @TomlComment(value={"Set this to false to regenerate default config commands"})
    public boolean configGenerated = false;

    public static Commands instance() {
        return INSTANCE;
    }

    public void loadConfig() throws IOException, IllegalStateException {
        if (!DiscordIntegration.commandsFile.exists()) {
            INSTANCE = new Commands();
            INSTANCE.saveConfig();
            return;
        }
        INSTANCE = new Toml().read(DiscordIntegration.commandsFile).to(Commands.class);
        if (!Commands.INSTANCE.configGenerated) {
            Commands.INSTANCE.commands.customCommands = defaultCommands;
            Commands.INSTANCE.configGenerated = true;
        }
        INSTANCE.saveConfig();
    }

    public void saveConfig() throws IOException {
        if (!DiscordIntegration.commandsFile.exists()) {
            if (!DiscordIntegration.commandsFile.getParentFile().exists()) {
                DiscordIntegration.commandsFile.getParentFile().mkdirs();
            }
            DiscordIntegration.commandsFile.createNewFile();
        }
        TomlWriter w = new TomlWriter.Builder().indentValuesBy(2).indentTablesBy(4).padArrayDelimitersBy(2).build();
        w.write((Object)this, DiscordIntegration.commandsFile);
    }

    static {
        ArrayList<ConfigCommand> defaultCmds = new ArrayList<ConfigCommand>();
        ConfigCommand kick = new ConfigCommand();
        kick.name = "kick";
        kick.description = "Kicks an player from the Server";
        kick.mcCommand = "kick %player% %reason%";
        kick.args = new ConfigCommand.CommandArgument[]{new ConfigCommand.CommandArgument("player", "The player to be kicked"), new ConfigCommand.CommandArgument("reason", "Reason for the kick", true)};
        kick.adminOnly = true;
        defaultCmds.add(kick);
        ConfigCommand stop = new ConfigCommand();
        stop.name = "stop";
        stop.description = "Stops the server";
        stop.mcCommand = "stop";
        stop.adminOnly = true;
        defaultCmds.add(stop);
        ConfigCommand kill = new ConfigCommand();
        kill.name = "kill";
        kill.description = "Kills an Player or Entity";
        kill.mcCommand = "kill %target%";
        kill.adminOnly = true;
        kill.args = new ConfigCommand.CommandArgument[]{new ConfigCommand.CommandArgument("target", "The target(s) for the kill command.")};
        defaultCmds.add(kill);
        defaultCommands = defaultCmds.toArray(new ConfigCommand[0]);
        INSTANCE = new Commands();
    }

    public static class CommandsCont {
        public ConfigCommand[] customCommands = new ConfigCommand[0];
    }
}

