/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.dcintegration.common.storage.linking;

import dcshadow.com.google.gson.JsonObject;
import dcshadow.com.google.gson.stream.JsonReader;
import dcshadow.org.apache.commons.collections4.KeyValue;
import dcshadow.org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import de.erdbeerbaerlp.dcintegration.common.DiscordIntegration;
import de.erdbeerbaerlp.dcintegration.common.storage.Configuration;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerLink;
import de.erdbeerbaerlp.dcintegration.common.storage.linking.PlayerSettings;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;

public class LinkManager {
    private static final String API_URL = "https://api.erdbeerbaerlp.de/dcintegration/link";
    private static ArrayList<PlayerLink> linkCache = new ArrayList();
    private static final ArrayList<String> nonexistentPlayerUUIDs = new ArrayList();
    public static final HashMap<Integer, KeyValue<Instant, UUID>> pendingLinks = new HashMap();
    public static final HashMap<Integer, KeyValue<Instant, UUID>> pendingBedrockLinks = new HashMap();

    public static void load() {
        if (Configuration.instance().linking.enableLinking) {
            linkCache = new ArrayList<PlayerLink>(Arrays.asList(DiscordIntegration.INSTANCE.getDatabaseInterface().getAllLinks()));
            DiscordIntegration.LOGGER.debug("LinkManager load | cache: " + linkCache);
        }
    }

    public static void save() {
        if (Configuration.instance().linking.enableLinking) {
            linkCache.forEach(l -> DiscordIntegration.INSTANCE.getDatabaseInterface().addLink((PlayerLink)l));
        }
    }

    public static boolean checkGlobalAPI(UUID uuid) {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            return false;
        }
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        if (!Configuration.instance().linking.globalLinking) {
            return false;
        }
        if (nonexistentPlayerUUIDs.contains(uuid.toString())) {
            return false;
        }
        if (LinkManager.isJavaPlayerLinked(uuid)) {
            return true;
        }
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL("https://api.erdbeerbaerlp.de/dcintegration/link?uuid=" + uuid.toString().replace("-", "")).openConnection();
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(1000);
            connection.setRequestMethod("GET");
            JsonObject o = (JsonObject)DiscordIntegration.gson.fromJson(new JsonReader(new InputStreamReader(connection.getInputStream())), (Type)((Object)JsonObject.class));
            if (o.has("dcID") && !o.get("dcID").getAsString().isEmpty()) {
                connection.disconnect();
                if (LinkManager.addLink(new PlayerLink(o.get("dcID").getAsString(), uuid.toString(), "", o.get("settings") == null ? new PlayerSettings() : DiscordIntegration.gson.fromJson(o.get("settings"), PlayerSettings.class)))) {
                    LinkManager.save();
                    return true;
                }
            }
            connection.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        nonexistentPlayerUUIDs.add(uuid.toString());
        return false;
    }

    public static ArrayList<PlayerLink> getAllLinks() {
        return linkCache;
    }

    public static boolean unlinkPlayer(String discordID) {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            return false;
        }
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        linkCache.removeIf(link -> link.discordID.equals(discordID));
        DiscordIntegration.INSTANCE.getDatabaseInterface().removeLink(discordID);
        return true;
    }

    public static boolean linkPlayer(String discordID, UUID player) throws IllegalArgumentException {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode() || player.equals(DiscordIntegration.dummyUUID)) {
            return false;
        }
        if (LinkManager.isDiscordUserLinkedToJava(discordID) || LinkManager.isPlayerLinked(player)) {
            throw new IllegalArgumentException("One link side already exists");
        }
        DiscordIntegration.LOGGER.info("LinkManager linkPlayer | discordID:" + discordID + ", player:" + player);
        return LinkManager.addLink(new PlayerLink(discordID, player.toString(), "", new PlayerSettings()));
    }

    public static boolean linkBedrockPlayer(String discordID, UUID bedrockPlayer) throws IllegalArgumentException {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode() || bedrockPlayer.equals(DiscordIntegration.dummyUUID)) {
            return false;
        }
        if (LinkManager.isDiscordUserLinkedToBedrock(discordID) || LinkManager.isPlayerLinked(bedrockPlayer)) {
            throw new IllegalArgumentException("One link side already exists");
        }
        boolean ignoringMessages = DiscordIntegration.INSTANCE.ignoringPlayers.contains(bedrockPlayer);
        PlayerLink link = LinkManager.isDiscordUserLinkedToJava(discordID) ? LinkManager.getLink(discordID, null) : new PlayerLink(discordID, "", bedrockPlayer.toString(), new PlayerSettings());
        link.floodgateUUID = bedrockPlayer.toString();
        link.settings.ignoreDiscordChatIngame = ignoringMessages;
        if (ignoringMessages) {
            DiscordIntegration.INSTANCE.ignoringPlayers.remove(bedrockPlayer);
        }
        return LinkManager.addLink(link);
    }

    public static boolean isJavaPlayerLinked(UUID player) {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            return false;
        }
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        for (PlayerLink o : LinkManager.getAllLinks()) {
            if (o.mcPlayerUUID == null || o.mcPlayerUUID.isEmpty() || !o.mcPlayerUUID.equals(player.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDiscordUserLinkedToJava(String discordID) {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            return false;
        }
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        for (PlayerLink o : LinkManager.getAllLinks()) {
            if (o.discordID.isEmpty() || !o.discordID.equals(discordID)) continue;
            return o.mcPlayerUUID != null && !o.mcPlayerUUID.isEmpty();
        }
        return false;
    }

    public static boolean isDiscordUserLinked(String discordID) {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            return false;
        }
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        if (LinkManager.isDiscordUserLinkedToJava(discordID)) {
            return true;
        }
        return LinkManager.isDiscordUserLinkedToBedrock(discordID);
    }

    public static boolean isDiscordUserLinkedToBedrock(String discordID) {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            return false;
        }
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        for (PlayerLink o : LinkManager.getAllLinks()) {
            if (o.discordID.isEmpty() || !o.discordID.equals(discordID)) continue;
            return o.floodgateUUID != null && !o.floodgateUUID.isEmpty();
        }
        return false;
    }

    public static boolean isPlayerLinked(UUID player) {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            return false;
        }
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        if (LinkManager.isJavaPlayerLinked(player)) {
            return true;
        }
        return LinkManager.isBedrockPlayerLinked(player);
    }

    public static boolean isBedrockPlayerLinked(UUID player) {
        if (!DiscordIntegration.INSTANCE.getServerInterface().isOnlineMode()) {
            return false;
        }
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        for (PlayerLink o : LinkManager.getAllLinks()) {
            if (o.floodgateUUID == null || o.floodgateUUID.isEmpty() || !o.floodgateUUID.equals(player.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean addLink(PlayerLink l) {
        if (!Configuration.instance().linking.enableLinking) {
            return false;
        }
        if (l.discordID == null) {
            return false;
        }
        PlayerLink tmp = null;
        for (PlayerLink link : LinkManager.getAllLinks()) {
            if (!link.discordID.equals(l.discordID) && (link.mcPlayerUUID == null || link.mcPlayerUUID.isEmpty() || !link.mcPlayerUUID.equals(l.mcPlayerUUID)) && (link.floodgateUUID == null || link.floodgateUUID.isEmpty() || !link.floodgateUUID.equals(l.floodgateUUID))) continue;
            tmp = link;
        }
        if (tmp != null) {
            linkCache.remove(tmp);
        }
        DiscordIntegration.LOGGER.debug("LinkManager addLink | tmp:" + tmp + ", l:" + l + ", linkCache:" + linkCache);
        linkCache.add(l);
        return true;
    }

    public static PlayerLink getLink(String discordID, UUID uuid) {
        if (!Configuration.instance().linking.enableLinking) {
            return null;
        }
        if (uuid == null && discordID == null) {
            return null;
        }
        if (discordID != null) {
            for (PlayerLink l : LinkManager.getAllLinks()) {
                if (!l.discordID.equals(discordID)) continue;
                return l;
            }
        }
        if (uuid != null) {
            for (PlayerLink l : LinkManager.getAllLinks()) {
                if (!(LinkManager.isFloodgateUUID(uuid) ? l.floodgateUUID.equals(uuid.toString()) : l.mcPlayerUUID.equals(uuid.toString()))) continue;
                return l;
            }
        }
        return null;
    }

    private static boolean isFloodgateUUID(UUID uuid) {
        return uuid.getMostSignificantBits() == 0L;
    }

    public static int genLinkNumber(UUID uniqueID) {
        return LinkManager.genLinkNumber(uniqueID, pendingLinks);
    }

    public static int genBedrockLinkNumber(UUID uniqueID) {
        return LinkManager.genLinkNumber(uniqueID, pendingBedrockLinks);
    }

    private static int genLinkNumber(UUID uniqueID, HashMap<Integer, KeyValue<Instant, UUID>> targetMap) {
        AtomicInteger r = new AtomicInteger(-1);
        targetMap.forEach((k, v) -> {
            if (((UUID)v.getValue()).equals(uniqueID)) {
                r.set((int)k);
            }
        });
        if (r.get() != -1) {
            return r.get();
        }
        do {
            r.set(new Random().nextInt(99999));
        } while (targetMap.containsKey(r.get()));
        targetMap.put(r.get(), new DefaultKeyValue<Instant, UUID>(Instant.now(), uniqueID));
        return r.get();
    }
}

